<?php


namespace Drop\Pvs\Model;


use Drop\Pvs\Logger\Logger;
use Magento\Authorization\Model\UserContextInterface;
use Magento\Framework\Bulk\BulkManagementInterface;
use Magento\Framework\Bulk\OperationInterface;
use Magento\AsynchronousOperations\Api\Data\OperationInterfaceFactory;
use Magento\Framework\DataObject\IdentityGeneratorInterface;
use Magento\Framework\Serialize\SerializerInterface;

class Publisher
{
    private $logger;
    private $bulkManagement;
    private $operationFactory;
    private $identityService;
    private $serializer;
    private $userContext;

    /**
     * Publisher constructor.
     * @param Logger $logger
     * @param BulkManagementInterface $bulkManagement
     * @param OperationInterfaceFactory $operationFactory
     * @param IdentityGeneratorInterface $identityService
     * @param SerializerInterface $serializer
     * @param UserContextInterface $userContext
     */
    public function __construct(
        Logger $logger,
        BulkManagementInterface $bulkManagement,
        OperationInterfaceFactory $operationFactory,
        IdentityGeneratorInterface $identityService,
        SerializerInterface $serializer,
        UserContextInterface $userContext
    )
    {
        $this->logger = $logger;
        $this->bulkManagement = $bulkManagement;
        $this->operationFactory = $operationFactory;
        $this->identityService = $identityService;
        $this->serializer = $serializer;
        $this->userContext = $userContext;
    }

    /**
     * @param $topicName
     * @param $publisherData
     * @param string $description
     * @return bool
     */
    public function publish($topicName, $publisherData, string $description = "")
    {
        // creo job per l'esportazione
        $data = [
            'data' => [
                'bulk_uuid'       => $this->identityService->generateId(),
                'topic_name'      => $topicName,
                'serialized_data' => $this->serializer->serialize($publisherData),
                'status'          => OperationInterface::STATUS_TYPE_OPEN,
            ]
        ];
        $operation = $this->operationFactory->create($data);

        try {
            return $this->bulkManagement->scheduleBulk(
                $bulkUuid,
                [$operation],
                $description,
                $this->userContext->getUserId()
            );
        } catch (\Exception $e) {
            $this->logger->error("[{$description} CRON] => {$e->getMessage()}");
        }

        return false;
    }
}
