<?php


namespace Drop\Pvs\Cron\Export;


use Drop\Pvs\Api\Export\ProductsInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\Search\FilterGroupBuilder;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\MessageQueue\PublisherInterface;

class Products
{
    const TOPIC_NAME = 'pvs.export.products';

    private $configuration;
    private $searchCriteriaBuilder;
    private $productRepository;
    private $publisher;
    private $productsInterface;
    private $filter;
    private $filterGroup;

    /**
     * Products constructor.
     * @param ConfigurationHelper $configurationHelper
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param ProductRepositoryInterface $productRepository
     * @param PublisherInterface $publisher
     * @param ProductsInterface $productsInterface
     */
    public function __construct(
        ConfigurationHelper $configurationHelper,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        ProductRepositoryInterface $productRepository,
        PublisherInterface $publisher,
        ProductsInterface $productsInterface,
        FilterBuilder $filter,
        FilterGroupBuilder $filterGroup
    )
    {
        $this->configuration = $configurationHelper;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->productRepository = $productRepository;
        $this->publisher = $publisher;
        $this->productsInterface = $productsInterface;
        $this->filter = $filter;
        $this->filterGroup = $filterGroup;
    }

    public function execute()
    {
        if (!$this->configuration->isEnabled() || !$this->configuration->isCommunicationEnabled()) {
            return;
        }

        $groups = [];
        $filtersOr[] = $this->filter->setField("is_pvs_exported")
            ->setValue(0)
            ->setConditionType('eq')
            ->create();
        $filtersOr[] = $this->filter->setField("is_pvs_exported")
            ->setConditionType('null')
            ->create();
        $groups[] = $this->filterGroup->setFilters($filtersOr)->create();

        $filterAnd = $this->filter->setField("type_id")
            ->setValue("simple")
            ->setConditionType('in')
            ->create();
        $groups[] = $this->filterGroup->setFilter($filterAnd)->create();

        $this->searchCriteriaBuilder->setFilterGroups($groups);
        if (!$products = $this->productRepository->getList($this->searchCriteriaBuilder->create())->getItems()) {
            return;
        }

        // creo job per l'esportazione
        $this->publisher->publish(self::TOPIC_NAME, $this->getPublisherData($products));
    }

    /**
     * @param $products
     * @param bool $saveLocal
     * @param bool $saveToFtp
     * @param bool $forced
     * @return ProductsInterface
     */
    public function getPublisherData($products, bool $saveLocal = false, bool $saveToFtp = true, bool $forced = false): ProductsInterface
    {
        $productsIds = [];
        foreach ($products as $product) {
            $productsIds[] = $product->getEntityId();
        }

        $this->productsInterface->setProductsIds($productsIds);
        $this->productsInterface->setSaveLocal($saveLocal);
        $this->productsInterface->setSaveToFtp($saveToFtp);
        $this->productsInterface->setIsForced($forced);

        return $this->productsInterface;
    }
}
