<?php


namespace Drop\Pvs\Cron\Export;

use Drop\Pvs\Api\FileInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Model\Ftp\Downloader;
use Magento\Framework\MessageQueue\PublisherInterface;

class Restock
{
    const TOPIC_NAME = 'pvs.export.restock';

    private $configuration;
    private $publisher;
    private $downloader;
    private $fileInterface;

    /**
     * Restock constructor.
     * @param ConfigurationHelper $configurationHelper
     * @param PublisherInterface $publisher
     * @param Downloader $downloader
     * @param FileInterface $fileInterface
     */
    public function __construct(
        ConfigurationHelper $configurationHelper,
        PublisherInterface $publisher,
        Downloader $downloader,
        FileInterface $fileInterface
    )
    {
        $this->configuration = $configurationHelper;
        $this->publisher = $publisher;
        $this->downloader = $downloader;
        $this->fileInterface = $fileInterface;
    }

    public function execute()
    {
        if (!$this->configuration->isEnabled() || !$this->configuration->isCommunicationEnabled()) {
            return;
        }

        if (!$files = $this->downloader->list($this->configuration->getRestockFilename(), $this->configuration->getFtpRestockDir())) {
            return;
        }

        // creo job per l'esportazione
        $this->publisher->publish(self::TOPIC_NAME, $this->getPublisherData($files));
    }

    /**
     * @param $files
     * @param bool $canDeleteFiles
     * @return FileInterface
     */
    public function getPublisherData($files, bool $canDeleteFiles = false): FileInterface
    {
        $this->fileInterface->setFiles($files);
        $this->fileInterface->setCanDeleteFiles($canDeleteFiles);

        return $this->fileInterface;
    }
}
