<?php

namespace Drop\Pvs\Block\Adminhtml\Form\Field;


use Drop\Pvs\Block\Adminhtml\Form\Field\CountryColumn;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;

class Carriers extends AbstractFieldArray
{
    /**
     * @var CountryColumn
     */
    private $countryRenderer;

    /**
     * Prepare rendering the new field by adding all the needed columns
     */
    protected function _prepareToRender()
    {
        $this->addColumn('country_id',
            [
                'label'    => __('Country'),
                'renderer' => $this->getCountryRenderer()
            ]);
        $this->addColumn('carrier_code', ['label' => __('Carrier Code'), 'class' => 'required-entry']);
        $this->addColumn('carrier_service', ['label' => __('Carrier Service'), 'class' => 'required-entry']);
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }

    /**
     * Prepare existing row data object
     *
     * @param DataObject $row
     * @throws LocalizedException
     */
    protected function _prepareArrayRow(DataObject $row): void
    {
        $options = [];

        $countryId = $row->getCountryId();
        if ($countryId !== null) {
            $options['option_' . $this->getCountryRenderer()->calcOptionHash($countryId)] = 'selected="selected"';
        }

        $row->setData('option_extra_attrs', $options);
    }

    private function getCountryRenderer()
    {
        if (!$this->countryRenderer) {
            $this->countryRenderer = $this->getLayout()->createBlock(
                CountryColumn::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }

        return $this->countryRenderer;
    }
}
