<?php


namespace Drop\Pvs\Cron\Export;

use Drop\Pvs\Api\Export\OrderInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Framework\MessageQueue\PublisherInterface;

class Order
{
    const TOPIC_NAME = 'pvs.export.order';

    private $searchCriteriaBuilder;
    private $configuration;
    private $orderRepository;
    private $publisher;
    private $orderInterface;

    /**
     * Order constructor.
     * @param ConfigurationHelper $configurationHelper
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param OrderRepositoryInterface $orderRepository
     * @param PublisherInterface $publisher
     * @param OrderInterface $orderInterface
     */
    public function __construct(
        ConfigurationHelper $configurationHelper,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        OrderRepositoryInterface $orderRepository,
        PublisherInterface $publisher,
        OrderInterface $orderInterface
    )
    {
        $this->configuration = $configurationHelper;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->orderRepository = $orderRepository;
        $this->publisher = $publisher;
        $this->orderInterface = $orderInterface;
    }

    public function execute()
    {
        if (!$this->configuration->isEnabled() || !$this->configuration->isOrderExportEnabled() || !$this->configuration->isCommunicationEnabled()) {
            return;
        }

        // recupero tutti gli ordini non esportati con lo stato definito da bo
        $this->searchCriteriaBuilder->addFilter("status", $this->configuration->getOrderStatusToExport());
        $this->searchCriteriaBuilder->addFilter("drop_pvs_exported", 0);
        if (!$orders = $this->orderRepository->getList($this->searchCriteriaBuilder->create())->getItems()) {
            return;
        }

        foreach ($orders as $order) {
            // creo job per l'esportazione
            $this->publisher->publish(self::TOPIC_NAME, $this->getPublisherData($order));
        }
    }

    /**
     * @param $order
     * @param bool $saveLocal
     * @param bool $saveToFtp
     * @param bool $forced
     * @return OrderInterface
     */
    public function getPublisherData($order, bool $saveLocal = false, bool $saveToFtp = true, bool $forced = false): OrderInterface
    {
        $this->orderInterface->setOrderId($order->getEntityId());
        $this->orderInterface->setSaveLocal($saveLocal);
        $this->orderInterface->setSaveToFtp($saveToFtp);
        $this->orderInterface->setIsForced($forced);

        return $this->orderInterface;
    }
}
