<?php
/**
 * @category    Magento 2
 * @copyright   Copyright (c) 2021 Drop (https://drop.it)
 * @author      Cavallaro <cavallaro@drop.it>
 */

namespace Drop\Pvs\Setup\Patch\Data;

use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Model\Entity\Attribute\Source\Boolean;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class AddPvsAttributes implements DataPatchInterface
{
    /** @var ModuleDataSetupInterface */
    private $moduleDataSetup;

    /** @var EavSetupFactory */
    private $eavSetupFactory;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    )
    {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $attributeSetId = $eavSetup->getAttributeSetId('catalog_product', 'Default');
        $eavSetup->addAttributeGroup('catalog_product', $attributeSetId, "Pvs");
        $eavSetup->addAttribute('catalog_product', 'is_pvs_exported', [
            'type'                    => 'int',
            'label'                   => 'Product Exported To Pvs',
            'input'                   => 'boolean',
            'source'                  => Boolean::class,
            'global'                  => ScopedAttributeInterface::SCOPE_GLOBAL,
            'used_in_product_listing' => true,
            'user_defined'            => false,
            'required'                => false,
            'default'                 => '1',
            'group'                   => 'Pvs'
        ]);

    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }
}
