<?php

namespace Drop\Pvs\Model\Ftp;

use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Helper\UtilitiesHelper;
use Drop\Pvs\Logger\Logger;
use Magento\Framework\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Io\File;
use Magento\Framework\Filesystem\Io\Ftp;

class Downloader
{
    private $configuration;
    private $ftp;
    private $logger;

    /**
     * Downloader constructor.
     * @param ConfigurationHelper $configurationHelper
     * @param Ftp $ftp
     * @param Logger $logger
     */
    public function __construct(
        ConfigurationHelper $configurationHelper,
        Ftp $ftp,
        Logger $logger
    )
    {
        $this->configuration = $configurationHelper;
        $this->ftp = $ftp;
        $this->logger = $logger;
    }

    /**
     * @param $ftpPath
     */
    public function connect($ftpPath)
    {
        $ftpParams = [
            'host'     => $this->configuration->getFtpHost(),
            'port'     => $this->configuration->getFtpPort(),
            'user'     => $this->configuration->getFtpUsername(),
            'password' => $this->configuration->getFtpPassword(),
            'path'     => $ftpPath,
            'passive'  => true
        ];
        try {
            $this->ftp->open($ftpParams);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
            $this->ftp->close();
        }
    }

    /**
     * @param $globalName
     * @param $ftpPath
     * @return array
     */
    public function list($globalName, $ftpPath): array
    {
        $this->connect($ftpPath);

        try {
            $ftpFiles = $this->ftp->ls();
            if (!$ftpFiles) {
                $this->ftp->close();
                return [];
            }

            $files = [];
            foreach ($ftpFiles as $file) {
                if (strpos($file["filename"], $globalName) === false) {
                    continue;
                }

                $files[] = $file["filename"];
            }
            $this->ftp->close();
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
            $this->ftp->close();
            return [];
        }

        return $files;
    }

    /**
     * @param $ftpPath
     * @param $filename
     * @return array|null
     */
    public function getFileContent($ftpPath, $filename)
    {
        $this->connect($ftpPath);

        try {
            $ftpFiles = $this->ftp->ls();
            if (!$ftpFiles) {
                $this->ftp->close();
                return [];
            }

            $content = null;
            foreach ($ftpFiles as $file) {
                if (strpos($file["filename"], $filename) === false) {
                    continue;
                }

                $content = $this->ftp->read($file["filename"]);
                break;
            }
            $this->ftp->close();
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
            $this->ftp->close();
            return [];
        }

        return $content;
    }

}
