<?php


namespace Drop\Pvs\Model\Consumer\Import;


use Drop\Pvs\Model\Xdocetes as XdocetesModel;
use Drop\Pvs\Api\Data\XdocetesInterfaceFactory;
use Drop\Pvs\Api\XdocetesRepositoryInterface;
use Drop\Pvs\Api\FileInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Helper\UtilitiesHelper;
use Drop\Pvs\Logger\Logger;
use Drop\Pvs\Model\Ftp\Modifier;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\File\Csv;
use Magento\Framework\Filesystem\Io\File;
use Magento\InventoryApi\Api\Data\SourceItemInterface;
use Magento\InventoryApi\Api\SourceItemsSaveInterface;

class Xdocetes
{

    private $logger;
    private $configuration;
    private $utilities;
    private $csv;
    private $modifier;
    private $searchCriteriaBuilder;
    private $xdocetesInterfaceFactory;
    private $xdocetesRepository;

    /**
     * Xdocetes constructor.
     * @param Logger $logger
     * @param ConfigurationHelper $configurationHelper
     * @param UtilitiesHelper $utilitiesHelper
     * @param Csv $csv
     * @param Modifier $modifier
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param XdocetesInterfaceFactory $xdocetesInterfaceFactory
     * @param XdocetesRepositoryInterface $xdocetesRepository
     */
    public function __construct(
        Logger $logger,
        ConfigurationHelper $configurationHelper,
        UtilitiesHelper $utilitiesHelper,
        Csv $csv,
        Modifier $modifier,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        XdocetesInterfaceFactory $xdocetesInterfaceFactory,
        XdocetesRepositoryInterface $xdocetesRepository
    )
    {
        $this->logger = $logger;
        $this->configuration = $configurationHelper;
        $this->utilities = $utilitiesHelper;
        $this->csv = $csv;
        $this->modifier = $modifier;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->xdocetesInterfaceFactory = $xdocetesInterfaceFactory;
        $this->xdocetesRepository = $xdocetesRepository;
    }

    /**
     * @param FileInterface $data
     */
    public function process(FileInterface $data)
    {
        if (!count($data->getFiles())) {
            return;
        }

        foreach ($data->getFiles() as $xdocetesFile) {
            $this->csv->setEnclosure($this->configuration->getCsvEnclosure());
            $this->csv->setDelimiter($this->configuration->getCsvSeparator());
            $csvData = $this->utilities->csvToArray($this->csv->getData($xdocetesFile));
            foreach ($csvData as $row) {
                switch ($row['COD_CMOV']) {
                    case 'RESO':
                        $this->processRmaResponse($row);
                        break;
                    case 'CAR':
                        $this->processRestockResponse($row);
                        break;
                }
            }

            $this->manageFtpFile($xdocetesFile, $data->getCanDeleteFiles());
        }
    }

    public function processRmaResponse($data)
    {
        //TODO: attualmente non faccio niente
    }

    /**
     * @param $data
     * @throws \Exception
     */
    public function processRestockResponse($data)
    {
        $this->searchCriteriaBuilder->addFilter(XdocetesModel::BOLLA, $data["BOLLA"]);
        $this->searchCriteriaBuilder->addFilter(XdocetesModel::DATA_BOLLA, $data["DATA_BOLLA"]);
        $this->searchCriteriaBuilder->addFilter(XdocetesModel::ORDINE, $data["ORDINE"]);
        $this->searchCriteriaBuilder->addFilter(XdocetesModel::COD_ART, $data["COD_ART"]);
        $this->searchCriteriaBuilder->addFilter(XdocetesModel::COD_MCON, $data["COD_MCON"]);
        if ($this->xdocetesRepository->getList($this->searchCriteriaBuilder->create())->getItems() > 0) {
            // record già registrato
            return;
        }

        $xdocetes = $this->xdocetesInterfaceFactory->create()
            ->setCodSocl($data['COD_SOCL'])
            ->setCodDicl($data['COD_DICL'])
            ->setCodDoce($data['COD_DOCE'])
            ->setStatus($data['STATUS'])
            ->setCodCliFor($data['COD_CLI_FOR'])
            ->setBolla($data['BOLLA'])
            ->setDataBolla(new \DateTime($data['DATA_BOLLA']))
            ->setOrdine($data['ORDINE'])
            ->setRigaDoce($data['RIGA_DOCE'])
            ->setCodArt($data['COD_ART'])
            ->setQtaRiga($data['QTA_RIGA'])
            ->setQtaVersata($data['QTA_VERSATA'])
            ->setQtaPlus($data['QTA_PLUS'])
            ->setCodUm($data['COD_UM'])
            ->setCodMcon($data['COD_MCON'])
            ->setCodCmov($data['COD_CMOV'])
            ->setDescArt($data['DESC_ART'])
            ->setFlNew($data['FL_NEW'])
            ->setDescMcon($data['DESC_MCON'])
            ->setCreatedAt(new \DateTime());
        $this->xdocetesRepository->save($xdocetes);
    }

    /**
     * @param $filename
     * @param $canDeleteFile
     */
    protected function manageFtpFile($filename, $canDeleteFile)
    {
        if ($canDeleteFile) {
            $this->modifier->delete($filename);
            return;
        }

        $this->modifier->moveToDone($filename);
    }
}
