<?php


namespace Drop\Pvs\Helper;


use Drop\Pvs\Model\Ftp\Downloader;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Driver\File;
use Magento\Framework\Stdlib\DateTime\DateTimeFactory;

class UtilitiesHelper extends AbstractHelper
{
    private $configuration;
    private $downloader;
    private $directoryList;
    private $driverFile;
    private $dateFactory;

    public function __construct(
        ConfigurationHelper $configurationHelper,
        Downloader $downloader,
        Context $context,
        DirectoryList $directoryList,
        File $driverFile,
        DateTimeFactory $dateFactory
    )
    {
        $this->configuration = $configurationHelper;
        $this->downloader = $downloader;
        $this->directoryList = $directoryList;
        $this->driverFile = $driverFile;
        $this->dateFactory = $dateFactory;
        parent::__construct($context);
    }

    /**
     * @param $csvData
     * @return array
     */
    public function csvToArray($csvData): array
    {
        $fields = [];
        $result = [];
        $i = 0;
        foreach ($csvData as $row) {
            if (empty($fields)) {
                $fields = $row;
                continue;
            }
            foreach ($row as $k => $value) {
                $result[$i][$fields[$k]] = $value;
            }
            $i++;
        }
        return $result;
    }

    /**
     * @param $dir
     * @return array
     */
    public function getLocalFiles($dir): array
    {
        $varPath = $this->directoryList->getPath(\Magento\Framework\App\Filesystem\DirectoryList::VAR_DIR);
        $pvsLocalFolder = "{$varPath}/pvs/tmp/{$dir}";

        return $this->driverFile->readDirectory($pvsLocalFolder);
    }

    /**
     * @param $xmlArray
     * @return \SimpleXMLElement
     */
    public function getXmlContentFromArray($xmlArray): \SimpleXMLElement
    {
        $content = new \SimpleXMLElement("<?xml version=\"1.0\"?>");
        foreach ($xmlArray as $item) {
            $node = $content->addChild('riga');
            foreach ($item as $key => $value) {
                $node->addChild($key, $value);
            }
        }

        return $content;
    }

    /**
     * @param $filename
     * @return string
     */
    public function completeFilenameWithDateTime($filename): string
    {
        $explName = explode('.', $filename);
        $datetime = $this->dateFactory->create()->gmtDate('YmdHis');

        return "{$explName[0]}{$datetime}.{$explName[1]}";
    }

    /**
     * @param $content
     * @param string $columnDelimiter
     * @param string $rowDelimiter
     * @return array
     */
    public function convertCsvContentToArray($content, string $columnDelimiter = ";", string $rowDelimiter = "\n"): array
    {
        $data = [];
        $rows = explode($rowDelimiter, $content);
        foreach ($rows as $row) {
            $data[] = explode($columnDelimiter, $row);
        }

        return $data;
    }

    /**
     * @return array
     */
    public function getCountriesCarrierArray(): array
    {
        $result = [];
        $files = $this->downloader->list($this->configuration->getCarrierFilename(), $this->configuration->getFtpCarrierDir());
        foreach ($files as $filename) {
            $data = $this->getAssocArrayFromFile($this->configuration->getFtpCarrierDir(), $filename);
            foreach ($data as $row) {
                $result[$row['Nazione']] = $row['Vettore'];
            }
            break;
        }

        return $result;
    }

    /**
     * @param $ftpPath
     * @param $filename
     * @return array
     */
    public function getAssocArrayFromFile($ftpPath, $filename): array
    {
        $content = $this->downloader->getFileContent($ftpPath, $filename);
        $contentArray = $this->convertCsvContentToArray($content);
        return $this->csvToArray($contentArray);
    }
}
