<?php


namespace Drop\Pvs\Console\Command\Import;


use Drop\Pvs\Cron\Import\Xdocetes as ImportXdoceTesCron;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Model\Consumer\Import\Xdocetes as ImportXdoceTesConsumer;
use Drop\Pvs\Model\Ftp\Downloader;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Driver\File;
use Magento\Framework\MessageQueue\PublisherInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class RestockResponse extends Command
{
    const FILENAME = 'filename';
    const DELETE = 'delete';
    const CREATE_JOB = 'create-job';

    private $configuration;
    private $publisher;
    private $downloader;
    private $appState;
    private $importXdoceTesConsumer;
    private $importXdoceTesCron;

    /**
     * Shipment constructor.
     * @param ConfigurationHelper $configuration
     * @param PublisherInterface $publisher
     * @param Downloader $downloader
     * @param State $appState
     * @param ImportXdoceTesConsumer $importXdoceTesConsumer
     * @param ImportXdoceTesCron $importXdoceTesCron
     */
    public function __construct(
        ConfigurationHelper $configuration,
        PublisherInterface $publisher,
        Downloader $downloader,
        State $appState,
        ImportXdoceTesConsumer $importXdoceTesConsumer,
        ImportXdoceTesCron $importXdoceTesCron
    )
    {
        $this->configuration = $configuration;
        $this->publisher = $publisher;
        $this->downloader = $downloader;
        $this->appState = $appState;
        $this->importXdoceTesConsumer = $importXdoceTesConsumer;
        $this->importXdoceTesCron = $importXdoceTesCron;
        parent::__construct();
    }

    protected function configure()
    {
        $options = [
            new InputOption(
                self::FILENAME,
                null,
                InputOption::VALUE_NONE,
                'get filename'
            ),
            new InputOption(
                self::DELETE,
                null,
                InputOption::VALUE_NONE,
                'if you want to delete files'
            ),
            new InputOption(
                self::CREATE_JOB,
                null,
                InputOption::VALUE_NONE,
                'if you want to create job'
            ),
        ];
        $this->setName('drop:pvs:import:restock-response');
        $this->setDescription('Manual restock response import from Pvs [directly or via job]');
        $this->setDefinition($options);
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|void
     * @throws \Magento\Framework\Exception\FileSystemException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->appState->setAreaCode(Area::AREA_ADMINHTML);

        $filename = $input->getOption(self::FILENAME) ?? $this->configuration->getRmaResponseFilename();
        $canDelete = $input->getOption(self::DELETE) ?? false;
        $createJob = $input->getOption(self::CREATE_JOB) ?? false;

        $files = $this->downloader->list($filename, $this->configuration->getFtpReadDir());

        $data = $this->importXdoceTesCron->getPublisherData($files, !$canDelete);

        if (!$createJob) {
            $this->importXdoceTesConsumer->process($data);
            return;
        }

        $this->publisher->publish(ImportXdoceTesCron::TOPIC_NAME, $data);
    }
}
