<?php


namespace Drop\Pvs\Console\Command\Import;


use Drop\Pvs\Cron\Import\Delivery as ImportDeliveryCron;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Helper\UtilitiesHelper;
use Drop\Pvs\Model\Consumer\Import\Delivery as ImportDeliveryConsumer;
use Drop\Pvs\Model\Ftp\Downloader;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Driver\File;
use Magento\Framework\MessageQueue\PublisherInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class Delivery extends Command
{
    const FILENAME = 'filename';
    const DELETE = 'delete';
    const CREATE_JOB = 'create-job';

    private $configuration;
    private $publisher;
    private $downloader;
    private $appState;
    private $importDeliveryConsumer;
    private $importDeliveryCron;

    /**
     * Delivery constructor.
     * @param ConfigurationHelper $configuration
     * @param PublisherInterface $publisher
     * @param Downloader $downloader
     * @param State $appState
     * @param ImportDeliveryConsumer $importDeliveryConsumer
     * @param ImportDeliveryCron $importDeliveryCron
     */
    public function __construct(
        ConfigurationHelper $configuration,
        PublisherInterface $publisher,
        Downloader $downloader,
        State $appState,
        ImportDeliveryConsumer $importDeliveryConsumer,
        ImportDeliveryCron $importDeliveryCron
    )
    {
        $this->configuration = $configuration;
        $this->publisher = $publisher;
        $this->downloader = $downloader;
        $this->appState = $appState;
        $this->importDeliveryConsumer = $importDeliveryConsumer;
        $this->importDeliveryCron = $importDeliveryCron;
        parent::__construct();
    }

    protected function configure()
    {
        $options = [
            new InputOption(
                self::FILENAME,
                null,
                InputOption::VALUE_NONE,
                'get filename'
            ),
            new InputOption(
                self::DELETE,
                null,
                InputOption::VALUE_NONE,
                'if you want to delete files'
            ),
            new InputOption(
                self::CREATE_JOB,
                null,
                InputOption::VALUE_NONE,
                'if you want to create job'
            ),
        ];
        $this->setName('drop:pvs:import:delivery');
        $this->setDescription('Manual delivery import from Pvs [directly or via job]');
        $this->setDefinition($options);
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|void
     * @throws \Magento\Framework\Exception\FileSystemException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->appState->setAreaCode(Area::AREA_ADMINHTML);

        $filename = $input->getOption(self::FILENAME) ?? $this->configuration->getDeliveredFilename();
        $canDelete = $input->getOption(self::DELETE) ?? false;
        $createJob = $input->getOption(self::CREATE_JOB) ?? false;

        $files = $this->downloader->list($filename, $this->configuration->getFtpReadDir());

        $data = $this->importDeliveryCron->getPublisherData($files, !$canDelete);

        if (!$createJob) {
            $this->importDeliveryConsumer->process($data);
            return;
        }

        $this->publisher->publish(ImportDeliveryCron::TOPIC_NAME, $data);
    }
}
