<?php
/**
 * Created by PhpStorm.
 * User: Alberto Pallotto
 * Date: 30/05/2019
 * Time: 15:33
 */

namespace Drop\ProductExport\Model;


class Export extends \Xtento\ProductExport\Model\Export
{
    protected function runExport($filters, $forcedCollectionItem = false)
    {
        try {
            @set_time_limit(0);
            $this->serverHelper->increaseMemoryLimit('2048M');
            if (!$this->getProfile()) {
                throw new LocalizedException(__('No profile to export specified.'));
            }
            if (preg_match('/\|merge\:/', $this->getProfile()->getXslTemplate())) {
                // Merge multiple profiles. Format: filename|merge:1,3,4,5 (<- profile ids)
                $generatedFiles = [];
                $mergeConfig = $this->getProfile()->getXslTemplate();
                $mergeResultFilename = array_shift(explode("|", $mergeConfig));
                $mergeConfig = str_replace($mergeResultFilename . "|merge:", '', $mergeConfig);
                $profileIds = explode(",", $mergeConfig);
                $recordsExported = 0;
                $generatedFile = "";
                foreach ($profileIds as $profileId) {
                    $profile = $this->profileFactory->create()->load($profileId);
                    if ($profile->getId()) {
                        $exportModel = $this->exportFactory->create()->setProfile($profile);
                        $exportedFiles = $exportModel->mergedExport($filters);
                        foreach ($exportedFiles as $exportedFilename => $exportedData) {
                            $generatedFile .= $exportedData;
                            $recordsExported += $this->_registry->registry('productexport_log')->getRecordsExported();
                        }
                    }
                }
                if ($this->_registry->registry('xtento_productexport_export_variables') !== null) {
                    $replaceableVariables = $this->_registry->registry('xtento_productexport_export_variables');
                    $generatedFilename = preg_replace(
                        array_keys($replaceableVariables),
                        array_values($replaceableVariables),
                        $mergeResultFilename
                    );
                    $generatedFiles[$generatedFilename] = $generatedFile;
                } else {
                    $generatedFiles[$mergeResultFilename] = $generatedFile;
                }
                // Re-register profile, log
                $this->_registry->unregister('productexport_log');
                $this->_registry->unregister('productexport_profile');
                $this->_registry->register('productexport_log', $this->getLogEntry());
                $this->_registry->register('productexport_profile', $this->getProfile());
                $this->getLogEntry()->setRecordsExported($recordsExported);
            } else {
                // Normal export, no merged export
                $returnArray = $this->exportObjects($filters, $forcedCollectionItem);
                // FIX URL IMAGE e PRICE
                $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                $productRepository = $objectManager->get('\Magento\Catalog\Model\ProductRepository');
                foreach ($returnArray as $key => $item):

                    if (isset($item['image'])):
                        $returnArray[$key]['image'] = str_replace('/pub/', '/', $item['image']);
                    endif;
                    if (isset($item['images'])):
                        foreach ($item['images'] as $counter => $image):
                            $returnArray[$key]['images'][$counter]['url'] = str_replace('/pub/', '/', $image['url']);
                        endforeach;
                    endif;
                    if (isset($item['price']) && $item['price'] == 0):
                        $storeId = $this->getProfile()->getStoreId();
                        $productObj = $productRepository->get($item["sku"], false, $storeId);
                        //rimosso perché i configurabili hanno price 0
                        //$returnArray[$key]['price'] = $productObj->getFinalPrice();
                        //prendo quindi il prezzo del primo figlio
                        $newPrice = 0;
                        $_children = $productObj->getTypeInstance()->getUsedProducts($productObj);
                        foreach ($_children as $child){
                            if($newPrice != 0){
                                continue;
                            }
                            $newPrice = $child->getFinalPrice();
                        }
                        $returnArray[$key]['price'] = $newPrice;
                    endif;

                endforeach;

                if (empty($returnArray) && !$this->getProfile()->getExportEmptyFiles()) {
                    throw new \Magento\Framework\Exception\LocalizedException(
                        __('0 %1 have been exported.', $this->entityHelper->getPluralEntityName($this->getProfile()->getEntity()))
                    );
                }
                $this->setReturnArrayWithObjects($returnArray);
                // Get output type
                if ($this->getProfile()->getOutputType() == 'csv') {
                    $type = 'csv';
                } else {
                    if ($this->getProfile()->getOutputType() == 'xml') {
                        $type = 'xml';
                    } else {
                        $type = 'xsl';
                    }
                }
                // Convert data
                if ($this->getProfile()->getExportOneFilePerObject()) {
                    // Create one file per exported object
                    $generatedFiles = [];
                    foreach ($this->getReturnArrayWithObjects() as $returnObject) {
                        $generatedFiles = array_merge(
                            $generatedFiles,
                            $this->objectManager->create(
                                '\Xtento\ProductExport\Model\Output\\' . ucfirst($type)
                            )->setProfile($this->getProfile())->convertData([$returnObject])
                        );
                    }
                } else {
                    // Create just one file for all exported objects
                    $generatedFiles = $this->objectManager->create(
                        '\Xtento\ProductExport\Model\Output\\' . ucfirst($type)
                    )->setProfile($this->getProfile())->convertData($this->getReturnArrayWithObjects());
                }
            }
            // Check for empty files
            if (!$this->getProfile()->getExportEmptyFiles()) {
                foreach ($generatedFiles as $filename => $data) {
                    if (strlen($data) === 0) {
                        unset($generatedFiles[$filename]);
                    }
                }
            }
            // Set generated files
            $this->setGeneratedFiles($generatedFiles);
            if (is_array($this->getReturnArrayWithObjects()) && $this->getLogEntry()) {
                $this->getLogEntry()->setRecordsExported(count($this->getReturnArrayWithObjects()));
            }

            return $generatedFiles;
        } catch (\Exception $e) {
            if ($this->getLogEntry()) {
                $result = \Xtento\ProductExport\Model\Log::RESULT_FAILED;
                if (preg_match('/have been exported/', $e->getMessage())) {
                    if ($this->getExportType() == self::EXPORT_TYPE_MANUAL || $this->getExportType() == self::EXPORT_TYPE_GRID
                    ) {
                        $result = \Xtento\ProductExport\Model\Log::RESULT_WARNING;
                    } else {
                        return [];
                    }
                }
                $this->getLogEntry()->setResult($result);
                $this->getLogEntry()->addResultMessage($e->getMessage());
                $this->afterExport();
            }
            if ($this->getExportType() == self::EXPORT_TYPE_MANUAL || $this->getExportType() == self::EXPORT_TYPE_GRID || $this->getExportType() == self::EXPORT_TYPE_TEST
            ) {
                throw new \Magento\Framework\Exception\LocalizedException(__($e->getMessage()));
            }
            return [];
        }
    }
}
