<?php

namespace Drop\Pdfgenerator\Helper;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;

class PdfMerge
{
    private $directoryList;
    private $filesystem;

    public function __construct(
        Filesystem    $filesystem,
        DirectoryList $directoryList
    )
    {
        $this->filesystem = $filesystem;
        $this->directoryList = $directoryList;
    }

    public function savePDF($fileData)
    {
        // Filename
        $fileName = $fileData["filename"] . date("Ymd_His") . ".pdf";

        // Set directory
        $writer = $this->filesystem->getDirectoryWrite(DirectoryList::VAR_DIR);

        $fullPath = 'tmp' . DIRECTORY_SEPARATOR . $fileName;

        // Create label file and write
        $file = $writer->openFile($fullPath, 'w');
        try {
            $file->lock();
            try {
                $file->write($fileData["filestream"]);
            } finally {
                $file->unlock();
            }
        } finally {
            $file->close();
        }

        return $fullPath;
    }

    /**
     * @throws \Magento\Framework\Exception\FileSystemException
     */
    public function clearPDF($array_files) {
        $writer = $this->filesystem->getDirectoryWrite( DirectoryList::VAR_DIR );
        $fullVarPath = $this->directoryList->getRoot() . DIRECTORY_SEPARATOR . DirectoryList::VAR_DIR . DIRECTORY_SEPARATOR;

        foreach ($array_files as $full_path) {
            $path = str_replace($fullVarPath,'',$full_path);
            $writer->delete($path);
        }
    }

    public function mergePDF($pdfArray, $filename)
    {
        $fullVarPath = $this->directoryList->getRoot() . DIRECTORY_SEPARATOR . DirectoryList::VAR_DIR . DIRECTORY_SEPARATOR;
        $outputName = $fullVarPath . $filename . ".pdf";

        try {
            $pdf2show = new \Zend_Pdf();
            $ex = new \Zend_Pdf_Resource_Extractor();
            foreach ($pdfArray as $file) {
                //checking if full path
                if (strpos($file, $this->directoryList->getRoot()) === false) {
                    //if not a full path, fix it
                    $file = $fullVarPath . $file;
                }
                $pdf = \Zend_Pdf::load($file);
                foreach ($pdf->pages as $pdfPage) {
                    $pdf2show->pages[] = $ex->clonePage($pdfPage);
                }
            }
            /** @var \Zend_Pdf $outputName */
            $pdf2show->save($outputName);
        } catch (\Exception $ex) {
            throw new \Exception("Error merging PDF Files: " . $ex->getMessage());
        }

        if (file_exists($outputName)) {
            return $outputName;
        }

        throw new \Exception("Can't merge PDF Files");
    }
}