<?php

namespace Drop\Pdfgenerator\Helper;

use Magento\Sales\Model\Order\Invoice;
use Magento\Sales\Model\Order\Creditmemo;
use Mirasvit\Rma\Model\Rma;

/**
 * Data class
 */
class Data extends \Eadesigndev\Pdfgenerator\Helper\Data
{
    /**
     * @var string
     */
    const EMAIL_CREDITMEMO = 'eadesign_pdfgenerator/general/email_creditmemo';

    /**
     * @var string
     */
    const EMAIL_INVOICE = 'eadesign_pdfgenerator/general/email_invoice';

    /**
     * @var string
     */
    const EMAIL_RMA = 'eadesign_pdfgenerator/general/email_rma';

    /**
     * Check if module will send email on new invoice or invoice update
     *
     * @return boolean
     */
    public function isEmailInvoice()
    {
        if ($this->isEnable()) {
            return $this->hasConfig(self::EMAIL_INVOICE);
        }
        return false;
    }

    /**
     * Check if module will send email on new creditmemo or creditmemo update
     *
     * @return boolean
     */
    public function isEmailCreditmemo()
    {
        if ($this->isEnable()) {
            return $this->hasConfig(self::EMAIL_CREDITMEMO);
        }
        return false;
    }

    /**
     * Check if module will send email rma
     *
     * @return boolean
     */
    public function isEmailRma()
    {
        if ($this->isEnable()) {
            return $this->hasConfig(self::EMAIL_RMA);
        }
        return false;
    }

    public function getTemplateStatus(Invoice $invoice)
    {
        return $this->_getTemplateStatus(
            $invoice,
            \Drop\Pdfgenerator\Model\Source\TemplateType::TYPE_INVOICE
        );
    }

    public function getTemplateStatusCreditMemo(Creditmemo $creditMemo)
    {
        return $this->_getTemplateStatus(
            $creditMemo,
            \Drop\Pdfgenerator\Model\Source\TemplateType::TYPE_CREDITMEMO
        );
    }

    public function getTemplateStatusRma(Rma $rma)
    {
        return $this->_getTemplateStatus(
            $rma,
            \Drop\Pdfgenerator\Model\Source\TemplateType::TYPE_RMA
        );
    }

    private function _getTemplateStatus($document, $templateType)
    {
        $stores = $document->getOrder()->getStoreId();
        $collection = $this->templateCollection->create();
        $collection->addStoreFilter($stores);
        $collection->addFieldToFilter('is_active', \Eadesigndev\Pdfgenerator\Model\Source\TemplateActive::STATUS_ENABLED);
        $collection->addFieldToFilter('template_default', \Eadesigndev\Pdfgenerator\Model\Source\AbstractSource::IS_DEFAULT);
        $collection->addFieldToFilter('template_type', $templateType);

        return $collection->getLastItem();
    }
}
