<?php
/**
 * EaDesgin
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE_AFL.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@eadesign.ro so we can send you a copy immediately.
 *
 * @category    eadesigndev_pdfgenerator
 * @copyright   Copyright (c) 2008-2016 EaDesign by Eco Active S.R.L.
 * @license     http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

namespace Drop\Pdfgenerator\Model\Source;

use Magento\Framework\View\Model\PageLayout\Config\BuilderInterface;

/**
 * Class >TemplateType
 */
class TemplateType extends \Eadesigndev\Pdfgenerator\Model\Source\TemplateType
{
    /**
     * Types
     */
    const TYPE_INVOICE = 1;
    const TYPE_CREDITMEMO = 2;
    const TYPE_RMA = 3;

    /**
     * Prepare post's statuses.
     *
     * @return array
     */
    public function getAvailable()
    {
        return [
            self::TYPE_INVOICE => __('Invoice'),
            self::TYPE_CREDITMEMO => __('Credit Memo'),
            self::TYPE_RMA => __('Rma')
        ];
    }
}
