<?php

namespace Drop\Pdfgenerator\Controller\Plugin;

use Mirasvit\Rma\Helper\Controller\Rma\GuestStrategy;
use Magento\Backend\Model\View\Result\ForwardFactory;
use Eadesigndev\Pdfgenerator\Model\PdfgeneratorRepository;
use Drop\Pdfgenerator\Helper\Pdf;
use Drop\Pdfgenerator\Helper\Data;
use Magento\Framework\Stdlib\DateTime\DateTime;
use Magento\Framework\App\Response\Http\FileFactory;
use Mirasvit\Rma\Model\RmaFactory;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\RequestInterface;
use Eadesigndev\Pdfgenerator\Model\Source\TemplateActive;
use Drop\Pdfgenerator\Model\Source\TemplateType;

if (class_exists(\Mirasvit\Rma\Controller\Rma\PrintAction::class)) {
    /**
     * RmaExtendedPrint
     */
    class RmaExtendedPrint extends \Mirasvit\Rma\Controller\Rma\PrintAction
    {
        private $guestStrategy;
        /**
         * @var ForwardFactory
         */
        private $resultForwardFactory;
        /**
         * @var PdfgeneratorRepository
         */
        private $pdfGeneratorRepository;
        /**
         * @var Pdf
         */
        private $helper;
        /**
         * @var DateTime
         */
        private $dateTime;
        /**
         * @var FileFactory
         */
        private $fileFactory;
        /**
         * @var RmaFactory
         */
        private $rmaFactory;
        /**
         * @var RequestInterface
         */
        private $request;
        /**
        * @var \Drop\RmaMirasvit\Helper\Data
        */
        private $helperData;

        /**
         * ExtendedPrint constructor.
         * @param GuestStrategy $guestStrategy
         * @param ForwardFactory $resultForwardFactory
         * @param PdfgeneratorRepository $pdfGeneratorRepository
         * @param Pdf $helper
         * @param DateTime $dateTime
         * @param FileFactory $fileFactory
         * @param RmaFactory $rmaFactory
         * @param RequestInterface $request
         * @param \Drop\RmaMirasvit\Helper\Data $helperData
         */
        public function __construct(
            GuestStrategy $guestStrategy,
            ForwardFactory $resultForwardFactory,
            PdfgeneratorRepository $pdfGeneratorRepository,
            Pdf $helper,
            DateTime $dateTime,
            FileFactory $fileFactory,
            RmaFactory $rmaFactory,
            RequestInterface $request,
            Data $helperData
        ) {
            $this->guestStrategy = $guestStrategy;
            $this->resultForwardFactory = $resultForwardFactory;
            $this->pdfGeneratorRepository = $pdfGeneratorRepository;
            $this->helper = $helper;
            $this->dateTime = $dateTime;
            $this->fileFactory = $fileFactory;
            $this->rmaFactory = $rmaFactory;
            $this->request = $request;
            $this->helperData = $helperData;
        }

        /**
         * @return \Magento\Framework\App\ResponseInterface
         */
        public function aroundExecute()
        {
            $id = $this->request->getParam('id');
            if (!$id) {
                $resultForward = $this->resultForwardFactory->create();
                $resultForward->forward('noroute');
                return $resultForward;
            }

            $rma = $this->rmaFactory->create()->getCollection()
              ->addFieldToFilter('guest_id', $id)
              ->getFirstItem();
            if (!$rma) {
                $resultForward = $this->resultForwardFactory->create();
                $resultForward->forward('noroute');
                return $resultForward;
            }

            $templateId =  $this->helperData->templateCollection->create()
              ->addStoreFilter($rma->getStoreId())
              ->addFieldToFilter('is_active', TemplateActive::STATUS_ENABLED)
              ->addFieldToFilter('template_type', TemplateType::TYPE_RMA)
              ->getFirstItem()
              ->getTemplateId()
          ;

            $templateModel = $this->pdfGeneratorRepository->getById($templateId);
            if (!$templateModel) {
                return $this->returnNoRoute();
            }

            $templateModel = $this->pdfGeneratorRepository->getById($templateId);
            $this->helper->setRma($rma);
            $this->helper->setTemplate($templateModel);

            $pdfFileData = $this->helper->template2Pdf();

            $date = $this->dateTime->date('Y-m-d_H-i-s');
            $fileName = $pdfFileData['filename'] . $date . '.pdf';

            return $this->fileFactory->create(
                $fileName,
                $pdfFileData['filestream'],
                DirectoryList::VAR_DIR,
                'application/pdf'
            );
        }
    }
} else {
    class RmaExtendedPrint
    {
    }
}
