<?php

namespace Drop\Pdfgenerator\Model\Email;

use Magento\Sales\Model\Order\Invoice;
use Magento\Sales\Model\Order\Creditmemo;

/**
 * Class SendBuilder
 */
class SendBuilder extends \Eadesigndev\Pdfgenerator\Model\Email\SenderBuilder
{
    /**
    * {@inheritDoc}
    */
    private function checkInvoice($vars)
    {
        if ($this->dataHelper->isEmailCreditmemo() && array_key_exists('creditmemo', $vars)) {
            $this->_checkDocument($vars['creditmemo']);
        }

        if ($this->dataHelper->isEmailInvoice() && array_key_exists('invoice', $vars)) {
            $this->_checkDocument($vars['invoice']);
        }

        return $this;
    }

    private function _checkDocument($document)
    {
        $helper = $this->helper;

        if (!$document instanceof Invoice && !$document instanceof Creditmemo) {
            throw new \Exception("Document type not allowed!");
        }

        $template = $this->dataHelper->getTemplateStatus($document);

        if ($document instanceof Creditmemo) {
            $template = $this->dataHelper->getTemplateStatusCreditMemo($document);
        }

        $helper->setDocumentType($document);

        if (empty($template->getId())) {
            return $this;
        }

        $helper->setTemplate($template);

        $pdfFileData = $helper->template2Pdf();

        $date = $this->dateTime->date('Y-m-d_H-i-s');

        $this->transportBuilder->addAttachment(
            $pdfFileData['filestream'],
            $pdfFileData['filename'] . $date . '.pdf'
        );
    }
}
