<?php

namespace Drop\Pdfgenerator\Helper;

use Magento\Sales\Model\Order\Invoice;
use Magento\Sales\Model\Order\Creditmemo;
use Magento\Framework\App\Filesystem\DirectoryList;
use Mpdf\Mpdf;
use Eadesigndev\Pdfgenerator\Model\Source\TemplatePaperOrientation;

/**
 * Pdf class
 * il template rma è gestito dal modulo DropRmaMirasvit.
 * purtroppo le nuove versione di pdfgenerator non permettono, se non tramite fork, la gestione corretta della classe.
 * per il momento è così.
 * @todo refactor.
 */
class Pdf extends \Eadesigndev\Pdfgenerator\Helper\Pdf
{
    /**
     * @var \Magento\Sales\Model\Order\Creditmemo
     */
    public $creditmemo;


    public function setDocumentType($document)
    {
        if ($document instanceof Invoice) {
            $this->setInvoice($document);
            return $this;
        }

        if ($document instanceof Creditmemo) {
            $this->setCreditmemo($document);
            return $this;
        }

        throw new \Exception("Document type not allowed!");
    }

    /**
     * @param Creditmemo $creditmemo
     * @return $this
     */
    public function setCreditmemo(Creditmemo $creditmemo)
    {
        $this->creditmemo = $creditmemo;
        $this->setOrder($creditmemo->getOrder());
        //Magento ^2.2 bug. Will be fixed in 2.3 https://github.com/magento/magento2/issues/6849
        //$this->setInvoice($creditmemo->getInvoice());
        foreach ($creditmemo->getOrder()->getInvoiceCollection() as $invoice) {
            $this->setInvoice($invoice);
        }

        return $this;
    }

    /**
     *
     * This will proces the template and the variables from the entity's
     *
     * @return string
     */
    public function _transport()
    {
        $invoice = $this->invoice;
        $order = $this->order;
        $paymentTitle= $order->getPayment()->getMethodInstance()->getTitle();


        $invoice = '';
        $invoice_comment = '';
        if ($this->invoice instanceof Invoice) {
            $invoice = $this->invoice;
            $invoice_comment = $invoice->getCustomerNoteNotify() ? $invoice->getCustomerNote() : '';
        }

        $creditmemo = '';
        $creditmemo_comment = '';
        if ($this->creditmemo instanceof Creditmemo) {
            $creditmemo = $this->creditmemo;
            $creditmemo_comment = $creditmemo->getCustomerNoteNotify() ? $creditmemo->getCustomerNote() : '';
        }

        $transport = [
            'order' => $order,
            'invoice' => $invoice,
            'creditmemo' => $creditmemo,
            'invoice_comment' => $invoice_comment,
            'creditmemo_comment' => $creditmemo_comment,
            'billing' => $order->getBillingAddress(),
            'payment_html' => $this->getPaymentHtml($order),
            'paymentInfo' => $paymentTitle,
            'store' => $order->getStore(),
            'formattedShippingAddress' => $this->getFormattedShippingAddress($order),
            'formattedBillingAddress' => $this->getFormattedBillingAddress($order),
            'logo_path' => $this->getFilesystem()->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath() . 'email/logo/' . $this->getHelper()->hasConfig('design/email/logo')
        ];

        $processor = $this->processor;
        $processor->setVariables($transport);
        $processor->setTemplate($this->template);
        $parts = $processor->processTemplate();

        return $parts;
    }

    /**
     * @param $parts
     * @return string
     */
    public function _eaPDFSettings($parts)
    {
        $templateModel = $this->template;


        if (!$templateModel->getTemplateCustomForm()) {
            /** @var mPDF $pdf */
            //@codingStandardsIgnoreLine
            $pdf = new Mpdf($this->config($templateModel));
        }

        if ($templateModel->getTemplateCustomForm()) {
            //@codingStandardsIgnoreLine
            $pdf = new Mpdf($this->config($templateModel));
        }

        $pdf->SetHTMLHeader($parts['header']);
        $pdf->SetHTMLFooter($parts['footer']);

        $pdf->WriteHTML($templateModel->getTemplateCss(), 1);

        //@codingStandardsIgnoreLine
        $pdf->WriteHTML('<body>' . html_entity_decode($parts['body']) . '</body>');
        $pdfToOutput = $pdf->Output('', 'S');


        return $pdfToOutput;
    }

    /**
     * @param Pdfgenerator $templateModel
     * @return array
     */
    private function config($templateModel)
    {
        $ori = $templateModel->getTemplatePaperOri();
        $orientation = $this->getTemplatePaperOrientation()->getAvailable();
        $finalOri = $orientation[$ori][0];
        $marginTop = $templateModel->getTemplateCustomT();
        $marginBottom = $templateModel->getTemplateCustomB();
        $paperForms = $this->getTemplatePaperForm()->getAvailable();
        $templatePaperForm = $templateModel->getTemplatePaperForm();
        if (!$templatePaperForm) {
            $templatePaperForm = 1;
        }
        $form = $paperForms[$templatePaperForm];
        if ($ori == TemplatePaperOrientation::TEMAPLATE_PAPER_LANDSCAPE) {
            $form = $paperForms[$templateModel->getTemplatePaperForm()] . '-' . $finalOri;
        }

        $config = [
          'mode' => 'utf-8',
          'format' => $form,
          'setAutoTopMargin' => 'pad',
          'setAutoBottomMargin' => 'pad',
          'autoMarginPadding' => 0,
          'default_font_size' => '',
          'default_font' => '',
          'margin_left' => $templateModel->getTemplateCustomL(),
          'margin_right' => $templateModel->getTemplateCustomR(),
          'margin_top' => 0,
          'margin_bottom' => 0,
          'margin_header' => $marginTop,
          'margin_footer' => $marginBottom,
          'tempDir' => $this->getDirectoryList()->getPath('tmp')
        ];

        if ($templateModel->getTemplateCustomForm()) {
            $config = [
              'mode' => 'utf-8',
              'format' => [
                  $templateModel->getTemplateCustomW(),
                  $templateModel->getTemplateCustomH()
              ],
              'setAutoTopMargin' => 'pad',
              'setAutoBottomMargin' => 'pad',
              'autoMarginPadding' => 0,
              'default_font_size' => '',
              'default_font' => '',
              'margin_left' => $templateModel->getTemplateCustomL(),
              'margin_right' => $templateModel->getTemplateCustomR(),
              'margin_top' => 0,
              'margin_bottom' => 0,
              'margin_header' => $marginTop,
              'margin_footer' => $marginBottom,
              'tempDir' => $this->getDirectoryList()->getPath('tmp')
          ];
        }

        return $config;
    }


    private function getFilesystem()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
        ->get(\Magento\Framework\Filesystem::class);
    }


    private function getHelper()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
        ->get(\Eadesigndev\Pdfgenerator\Helper\Data::class);
    }

    private function getTemplatePaperOrientation()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
        ->get(\Eadesigndev\Pdfgenerator\Model\Source\TemplatePaperOrientation::class);
    }

    private function getTemplatePaperForm()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
        ->get(\Eadesigndev\Pdfgenerator\Model\Source\TemplatePaperForm::class);
    }

    private function getDirectoryList()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
        ->get(\Magento\Framework\App\Filesystem\DirectoryList::class);
    }
}
