<?php

namespace Drop\Pdfgenerator\Helper;

use Magento\Sales\Model\Order\Invoice;
use Magento\Sales\Model\Order\Creditmemo;

/**
 * Pdf class
 */
class Pdf extends \Eadesigndev\Pdfgenerator\Helper\Pdf
{
    /**
     * @var \Magento\Sales\Model\Order\Creditmemo
     */
    public $creditmemo;


    public function setDocumentType($document)
    {
        if ($document instanceof Invoice) {
            $this->setInvoice($document);
            return $this;
        }

        if ($document instanceof Creditmemo) {
            $this->setCreditmemo($document);
            return $this;
        }

        throw new \Exception("Document type not allowed!");
    }

    /**
     * @param Creditmemo $creditmemo
     * @return $this
     */
    public function setCreditmemo(Creditmemo $creditmemo)
    {
        $this->creditmemo = $creditmemo;
        $this->setOrder($creditmemo->getOrder());
        //Magento ^2.2 bug. Will be fixed in 2.3 https://github.com/magento/magento2/issues/6849
        //$this->setInvoice($creditmemo->getInvoice());
        foreach ($creditmemo->getOrder()->getInvoiceCollection() as $invoice) {
            $this->setInvoice($invoice);
        }

        return $this;
    }

    /**
     *
     * This will proces the template and the variables from the entity's
     *
     * @return string
     */
    private function transport()
    {
        $invoice = $this->invoice;
        $order = $this->order;
        $paymentTitle= $order->getPayment()->getMethodInstance()->getTitle();


        $invoice = '';
        $invoice_comment = '';
        if ($this->invoice instanceof Invoice) {
            $invoice = $this->invoice;
            $invoice_comment = $invoice->getCustomerNoteNotify() ? $invoice->getCustomerNote() : '';
        }

        $creditmemo = '';
        $creditmemo_comment = '';
        if ($this->creditmemo instanceof Creditmemo) {
            $creditmemo = $this->creditmemo;
            $creditmemo_comment = $creditmemo->getCustomerNoteNotify() ? $creditmemo->getCustomerNote() : '';
        }

        $transport = [
            'order' => $order,
            'invoice' => $invoice,
            'creditmemo' => $creditmemo,
            'invoice_comment' => $invoice_comment,
            'creditmemo_comment' => $creditmemo_comment,
            'billing' => $order->getBillingAddress(),
            'payment_html' => $this->getPaymentHtml($order),
            'paymentInfo' => $paymentTitle,
            'store' => $order->getStore(),
            'formattedShippingAddress' => $this->getFormattedShippingAddress($order),
            'formattedBillingAddress' => $this->getFormattedBillingAddress($order),
            'logo_path' => $this->filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath() . 'email/logo/' . $this->helper->hasConfig('design/email/logo')
        ];

        $processor = $this->processor;
        $processor->setVariables($transport);
        $processor->setTemplate($this->template);
        $parts = $processor->processTemplate();

        return $parts;
    }

    /**
     * @param Pdfgenerator $templateModel
     * @return array
     */
    private function config($templateModel)
    {
        $ori = $templateModel->getTemplatePaperOri();
        $orientation = $this->templatePaperOrientation->getAvailable();
        $finalOri = $orientation[$ori][0];
        $marginTop = $templateModel->getTemplateCustomT();
        $marginBottom = $templateModel->getTemplateCustomB();
        $paperForms = $this->templatePaperForm->getAvailable();
        $templatePaperForm = $templateModel->getTemplatePaperForm();
        if (!$templatePaperForm) {
            $templatePaperForm = 1;
        }
        $form = $paperForms[$templatePaperForm];
        if ($ori == TemplatePaperOrientation::TEMAPLATE_PAPER_LANDSCAPE) {
            $form = $paperForms[$templateModel->getTemplatePaperForm()] . '-' . $finalOri;
        }

        $config = [
          'mode' => 'utf-8',
          'format' => $form,
          'setAutoTopMargin' => 'pad',
          'setAutoBottomMargin' => 'pad',
          'autoMarginPadding' => 0,
          'default_font_size' => '',
          'default_font' => '',
          'margin_left' => $templateModel->getTemplateCustomL(),
          'margin_right' => $templateModel->getTemplateCustomR(),
          'margin_top' => 0,
          'margin_bottom' => 0,
          'margin_header' => $marginTop,
          'margin_footer' => $marginBottom,
          'tempDir' => $this->directoryList->getPath('tmp')
        ];

        if ($templateModel->getTemplateCustomForm()) {
            $config = [
              'mode' => 'utf-8',
              'format' => [
                  $templateModel->getTemplateCustomW(),
                  $templateModel->getTemplateCustomH()
              ],
              'setAutoTopMargin' => 'pad',
              'setAutoBottomMargin' => 'pad',
              'autoMarginPadding' => 0,
              'default_font_size' => '',
              'default_font' => '',
              'margin_left' => $templateModel->getTemplateCustomL(),
              'margin_right' => $templateModel->getTemplateCustomR(),
              'margin_top' => 0,
              'margin_bottom' => 0,
              'margin_header' => $marginTop,
              'margin_footer' => $marginBottom,
              'tempDir' => $this->directoryList->getPath('tmp')
          ];
        }

        return $config;
    }
}
