<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Drop\PaymentTransactionFailed\Helper;

use Magento\Framework\App\ProductMetadataInterface;

class VersionCompare
{
    /**
     * @param $ver
     * @param string $operator
     *
     * @return mixed
     */
    public static function versionCompare($ver, $operator = '>=')
    {
    	$productMetadata = \Magento\Framework\App\ObjectManager::getInstance()
            ->get(ProductMetadataInterface::class);
        $version = $productMetadata->getVersion();

        return version_compare($version, $ver, $operator);
    }
}