<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Drop\PaymentTransactionFailed\Helper;

use Drop\PaymentTransactionFailed\Helper\VersionCompare;

if(VersionCompare::versionCompare('2.3.1')){
/**
 * Checkout default helper
 *
 * @author      Magento Core Team <core@magentocommerce.com>
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class Data extends \Magento\Checkout\Helper\Data
{
    /**
     * Send email id payment was failed
     *
     * @param \Magento\Quote\Model\Quote $checkout
     * @param string $message
     * @param string $checkoutType
     * @return $this
     */
    public function sendPaymentFailedEmail(
        \Magento\Quote\Model\Quote $checkout,
        string $message,
        string $checkoutType = 'onepage'
    ): Data {
        $this->inlineTranslation->suspend();

        $template = $this->scopeConfig->getValue(
            'checkout/payment_failed/template',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $checkout->getStoreId()
        );

        $copyTo = $this->_getEmails('checkout/payment_failed/copy_to', $checkout->getStoreId());
        $copyMethod = $this->scopeConfig->getValue(
            'checkout/payment_failed/copy_method',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $checkout->getStoreId()
        );
        $bcc = [];
        if ($copyTo && $copyMethod == 'bcc') {
            $bcc = $copyTo;
        }

        $_receiver = $this->scopeConfig->getValue(
            'checkout/payment_failed/receiver',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $checkout->getStoreId()
        );
        $sendTo = [
            [
                'email' => $this->scopeConfig->getValue(
                    'trans_email/ident_' . $_receiver . '/email',
                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                    $checkout->getStoreId()
                ),
                'name' => $this->scopeConfig->getValue(
                    'trans_email/ident_' . $_receiver . '/name',
                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                    $checkout->getStoreId()
                ),
            ],
        ];

        if ($copyTo && $copyMethod == 'copy') {
            foreach ($copyTo as $email) {
                $sendTo[] = ['email' => $email, 'name' => null];
            }
        }
        $shippingMethod = '';
        if ($shippingInfo = $checkout->getShippingAddress()->getShippingMethod()) {
            $data = explode('_', $shippingInfo);
            $shippingMethod = $data[0];
        }

        $paymentMethod = '';
        if ($paymentInfo = $checkout->getPayment()) {
            $paymentMethod = $paymentInfo->getMethod();
        }

        $items = '';
        foreach ($checkout->getAllVisibleItems() as $_item) {
            /* @var $_item \Magento\Quote\Model\Quote\Item */
            $items .=
                $_item->getProduct()->getName() . '  x ' . $_item->getQty() . '  ' . $checkout->getStoreCurrencyCode()
                . ' ' . $_item->getProduct()->getFinalPrice(
                    $_item->getQty()
                ) . "\n";
        }
        $total = $checkout->getStoreCurrencyCode() . ' ' . $checkout->getGrandTotal();

        foreach ($sendTo as $recipient) {
            $transport = $this->_transportBuilder->setTemplateIdentifier(
                $template
            )->setTemplateOptions(
                [
                    'area' => \Magento\Backend\App\Area\FrontNameResolver::AREA_CODE,
                    'store' => \Magento\Store\Model\Store::DEFAULT_STORE_ID
                ]
            )->setTemplateVars(
                [
                    'store_code' => $checkout->getStore()->getName() . " (" . $checkout->getStore()->getCode() . ")",
                    'store_name' => $this->scopeConfig->getValue(
                        'general/store_information/name',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                    'reason' => $message,
                    'checkoutType' => $checkoutType,
                    'dateAndTime' => $this->_localeDate->formatDateTime(
                        new \DateTime(),
                        \IntlDateFormatter::MEDIUM,
                        \IntlDateFormatter::MEDIUM
                    ),
                    'customer' => $checkout->getCustomerFirstname() . ' ' . $checkout->getCustomerLastname(),
                    'customerEmail' => $checkout->getCustomerEmail(),
                    'billingAddress' => $checkout->getBillingAddress(),
                    'shippingAddress' => $checkout->getShippingAddress(),
                    'shippingMethod' => $this->scopeConfig->getValue(
                        'carriers/' . $shippingMethod . '/title',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                    'paymentMethod' => $this->scopeConfig->getValue(
                        'payment/' . $paymentMethod . '/title',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                    'items' => nl2br($items),
                    'total' => $total,
                ]
            )->setFrom(
                $this->scopeConfig->getValue(
                    'checkout/payment_failed/identity',
                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                    $checkout->getStoreId()
                )
            )->addTo(
                $recipient['email'],
                $recipient['name']
            )->addBcc(
                $bcc
            )->getTransport();

            $transport->sendMessage();
        }

        $this->inlineTranslation->resume();

        return $this;
    }
}
}else if(VersionCompare::versionCompare('2.2.5', '<=')){
	/**
	 * Checkout default helper
	 *
	 * @author      Magento Core Team <core@magentocommerce.com>
	 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
	 */
	class Data extends \Magento\Checkout\Helper\Data
	{
	    /**
	     * Send email id payment was failed
	     *
	     * @param \Magento\Quote\Model\Quote $checkout
	     * @param string $message
	     * @param string $checkoutType
	     * @return $this
	     * @SuppressWarnings(PHPMD.CyclomaticComplexity)
	     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
	     */
	    public function sendPaymentFailedEmail($checkout, $message, $checkoutType = 'onepage')
	    {
	        $this->inlineTranslation->suspend();

	        $template = $this->scopeConfig->getValue(
	            'checkout/payment_failed/template',
	            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	            $checkout->getStoreId()
	        );

	        $copyTo = $this->_getEmails('checkout/payment_failed/copy_to', $checkout->getStoreId());
	        $copyMethod = $this->scopeConfig->getValue(
	            'checkout/payment_failed/copy_method',
	            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	            $checkout->getStoreId()
	        );
	        $bcc = [];
	        if ($copyTo && $copyMethod == 'bcc') {
	            $bcc = $copyTo;
	        }

	        $_receiver = $this->scopeConfig->getValue(
	            'checkout/payment_failed/receiver',
	            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	            $checkout->getStoreId()
	        );
	        $sendTo = [
	            [
	                'email' => $this->scopeConfig->getValue(
	                    'trans_email/ident_' . $_receiver . '/email',
	                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	                    $checkout->getStoreId()
	                ),
	                'name' => $this->scopeConfig->getValue(
	                    'trans_email/ident_' . $_receiver . '/name',
	                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	                    $checkout->getStoreId()
	                ),
	            ],
	        ];

	        if ($copyTo && $copyMethod == 'copy') {
	            foreach ($copyTo as $email) {
	                $sendTo[] = ['email' => $email, 'name' => null];
	            }
	        }
	        $shippingMethod = '';
	        if ($shippingInfo = $checkout->getShippingAddress()->getShippingMethod()) {
	            $data = explode('_', $shippingInfo);
	            $shippingMethod = $data[0];
	        }

	        $paymentMethod = '';
	        if ($paymentInfo = $checkout->getPayment()) {
	            $paymentMethod = $paymentInfo->getMethod();
	        }

	        $items = '';
	        foreach ($checkout->getAllVisibleItems() as $_item) {
	            /* @var $_item \Magento\Quote\Model\Quote\Item */
	            $items .=
	                $_item->getProduct()->getName() . '  x ' . $_item->getQty() . '  ' . $checkout->getStoreCurrencyCode()
	                . ' ' . $_item->getProduct()->getFinalPrice(
	                    $_item->getQty()
	                ) . "\n";
	        }
	        $total = $checkout->getStoreCurrencyCode() . ' ' . $checkout->getGrandTotal();

	        foreach ($sendTo as $recipient) {
	            $transport = $this->_transportBuilder->setTemplateIdentifier(
	                $template
	            )->setTemplateOptions(
	                [
	                    'area' => \Magento\Backend\App\Area\FrontNameResolver::AREA_CODE,
	                    'store' => \Magento\Store\Model\Store::DEFAULT_STORE_ID
	                ]
	            )->setTemplateVars(
	                [
	                    'store_code' => $checkout->getStore()->getName() . " (" . $checkout->getStore()->getCode() . ")",
	                    'store_name' => $this->scopeConfig->getValue(
	                        'general/store_information/name',
	                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
	                    ),
	                    'reason' => $message,
	                    'checkoutType' => $checkoutType,
	                    'dateAndTime' => $this->_localeDate->formatDateTime(
	                        new \DateTime(),
	                        \IntlDateFormatter::MEDIUM,
	                        \IntlDateFormatter::MEDIUM
	                    ),
	                    'customer' => $checkout->getCustomerFirstname() . ' ' . $checkout->getCustomerLastname(),
	                    'customerEmail' => $checkout->getCustomerEmail(),
	                    'billingAddress' => $checkout->getBillingAddress(),
	                    'shippingAddress' => $checkout->getShippingAddress(),
	                    'shippingMethod' => $this->scopeConfig->getValue(
	                        'carriers/' . $shippingMethod . '/title',
	                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
	                    ),
	                    'paymentMethod' => $this->scopeConfig->getValue(
	                        'payment/' . $paymentMethod . '/title',
	                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
	                    ),
	                    'items' => nl2br($items),
	                    'total' => $total,
	                ]
	            )->setFrom(
	                $this->scopeConfig->getValue(
	                    'checkout/payment_failed/identity',
	                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	                    $checkout->getStoreId()
	                )
	            )->addTo(
	                $recipient['email'],
	                $recipient['name']
	            )->addBcc(
	                $bcc
	            )->getTransport();

	            $transport->sendMessage();
	        }

	        $this->inlineTranslation->resume();

	        return $this;
	    }
	}
}else if(VersionCompare::versionCompare('2.3.0', '<=')){
	/**
	 * Checkout default helper
	 *
	 * @author      Magento Core Team <core@magentocommerce.com>
	 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
	 */
	class Data extends \Magento\Checkout\Helper\Data
	{
	    /**
	     * Send email id payment was failed
	     *
	     * @param \Magento\Quote\Model\Quote $checkout
	     * @param string $message
	     * @param string $checkoutType
	     * @return $this
	     */
	    public function sendPaymentFailedEmail(
	        \Magento\Quote\Model\Quote $checkout,
	        string $message,
	        string $checkoutType = 'onepage'
	    ): \Magento\Checkout\Helper\Data {
	        $this->inlineTranslation->suspend();

	        $template = $this->scopeConfig->getValue(
	            'checkout/payment_failed/template',
	            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	            $checkout->getStoreId()
	        );

	        $copyTo = $this->_getEmails('checkout/payment_failed/copy_to', $checkout->getStoreId());
	        $copyMethod = $this->scopeConfig->getValue(
	            'checkout/payment_failed/copy_method',
	            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	            $checkout->getStoreId()
	        );
	        $bcc = [];
	        if ($copyTo && $copyMethod == 'bcc') {
	            $bcc = $copyTo;
	        }

	        $_receiver = $this->scopeConfig->getValue(
	            'checkout/payment_failed/receiver',
	            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	            $checkout->getStoreId()
	        );
	        $sendTo = [
	            [
	                'email' => $this->scopeConfig->getValue(
	                    'trans_email/ident_' . $_receiver . '/email',
	                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	                    $checkout->getStoreId()
	                ),
	                'name' => $this->scopeConfig->getValue(
	                    'trans_email/ident_' . $_receiver . '/name',
	                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	                    $checkout->getStoreId()
	                ),
	            ],
	        ];

	        if ($copyTo && $copyMethod == 'copy') {
	            foreach ($copyTo as $email) {
	                $sendTo[] = ['email' => $email, 'name' => null];
	            }
	        }
	        $shippingMethod = '';
	        if ($shippingInfo = $checkout->getShippingAddress()->getShippingMethod()) {
	            $data = explode('_', $shippingInfo);
	            $shippingMethod = $data[0];
	        }

	        $paymentMethod = '';
	        if ($paymentInfo = $checkout->getPayment()) {
	            $paymentMethod = $paymentInfo->getMethod();
	        }

	        $items = '';
	        foreach ($checkout->getAllVisibleItems() as $_item) {
	            /* @var $_item \Magento\Quote\Model\Quote\Item */
	            $items .=
	                $_item->getProduct()->getName() . '  x ' . $_item->getQty() . '  ' . $checkout->getStoreCurrencyCode()
	                . ' ' . $_item->getProduct()->getFinalPrice(
	                    $_item->getQty()
	                ) . "\n";
	        }
	        $total = $checkout->getStoreCurrencyCode() . ' ' . $checkout->getGrandTotal();

	        foreach ($sendTo as $recipient) {
	            $transport = $this->_transportBuilder->setTemplateIdentifier(
	                $template
	            )->setTemplateOptions(
	                [
	                    'area' => \Magento\Backend\App\Area\FrontNameResolver::AREA_CODE,
	                    'store' => \Magento\Store\Model\Store::DEFAULT_STORE_ID
	                ]
	            )->setTemplateVars(
	                [
	                    'store_code' => $checkout->getStore()->getName() . " (" . $checkout->getStore()->getCode() . ")",
	                    'store_name' => $this->scopeConfig->getValue(
	                        'general/store_information/name',
	                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
	                    ),
	                    'reason' => $message,
	                    'checkoutType' => $checkoutType,
	                    'dateAndTime' => $this->_localeDate->formatDateTime(
	                        new \DateTime(),
	                        \IntlDateFormatter::MEDIUM,
	                        \IntlDateFormatter::MEDIUM
	                    ),
	                    'customer' => $checkout->getCustomerFirstname() . ' ' . $checkout->getCustomerLastname(),
	                    'customerEmail' => $checkout->getCustomerEmail(),
	                    'billingAddress' => $checkout->getBillingAddress(),
	                    'shippingAddress' => $checkout->getShippingAddress(),
	                    'shippingMethod' => $this->scopeConfig->getValue(
	                        'carriers/' . $shippingMethod . '/title',
	                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
	                    ),
	                    'paymentMethod' => $this->scopeConfig->getValue(
	                        'payment/' . $paymentMethod . '/title',
	                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
	                    ),
	                    'items' => nl2br($items),
	                    'total' => $total,
	                ]
	            )->setFrom(
	                $this->scopeConfig->getValue(
	                    'checkout/payment_failed/identity',
	                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
	                    $checkout->getStoreId()
	                )
	            )->addTo(
	                $recipient['email'],
	                $recipient['name']
	            )->addBcc(
	                $bcc
	            )->getTransport();

	            $transport->sendMessage();
	        }

	        $this->inlineTranslation->resume();

	        return $this;
	    }
	}
}