define([
    'Magento_Ui/js/form/element/abstract',
    'jquery'
], function (Abstract, $) {
    'use strict';

    return Abstract.extend({
        hideAllFields:function(){
            $(".oms-taxvat-field").hide();
            $(".oms-company-field").hide();
            $(".oms-destination-field").hide();
            $(".oms-fiscal-code-field").hide();
            //$(".oms-invoice-group").hide();
        },
        showInvoice: function(){
            $(".oms-invoice-group").show();
            this.hideAllFields();
        },
        hideInvoice: function(){
            $(".oms-invoice-group").hide();
        },

        showPrivateFields: function(){
            $(".oms-destination-field").show();
            $(".oms-fiscal-code-field").show();

            if ($(".oms-company-field input").val()) {
                $(".oms-company-field input").val('');
            }
            if ($(".oms-taxvat-field input").val()) {
                $(".oms-taxvat-field input").val('');
            }
        },

        showCompanyFields: function() {
            $(".oms-taxvat-field").show();
            $(".oms-company-field").show();

            if ($(".oms-fiscal-code-field input").val()) {
                $(".oms-fiscal-code-field input").val('');
            }

            if ($("select[name='country_id']").val()=="IT") {
                $(".oms-destination-field").show();
            }
        },

        setMandatoryInvoice: function() {
            $("#request_invoice").val(1);
            //$(".oms-invoice").hide();
            this.hideInvoice();
        },

        setOptionalInvoice: function() {
            $("#request_invoice").val(0);
            //$(".oms-invoice").show();
            this.showInvoice()
        }
    });
});
