define([
    'Drop_Oms/js/form/common',
    'jquery'
], function (OmsCommon, $) {
    'use strict';


    return OmsCommon.extend({

        self: null,

        /**
         * Initialize data
         */
        initialize: function () {
            this._super();

            this.debug = window.checkoutConfig.oms.debug;
            this.mandatory_countries = window.checkoutConfig.oms.mandatory_invoice_countries;

            this.checked = false;
            self = this;
        },

        requestInvoiceAfterLoadProcessor: function (checkbox) {


            var self = this;

            this.hideAllFields();

            //FA RIAPPARIRE LE CHECK QUANDO TORNO INDIETRO
            window.addEventListener('hashchange', function (ev, param) {


                if (ev.newURL.indexOf("#shipping")>1) {
                    self.checkMandatoryInvoice($('select[name="country_id"]').val());
                }
            });

            $("#show-invoice-fields").on('change', function(ev){

                self.hideAllFields();
                $(".choose-customer-typology").hide();
                if ($(this).is(':checked')){

                    $("#request_invoice").val(1);
                    $("#request_invoice").change();



                    if ($(".choose-customer-typology").data("can-choose")){
                        $(".choose-customer-typology").show();

                        var radioVal =  $('input[type=radio][name=customer_typology]:checked').val();

                        if (radioVal==0 || radioVal == undefined) {
                            self.showPrivateFields();
                        }else{
                            self.showCompanyFields();
                        }

                    }else{
                        self.showCompanyFields();
                    }

                }else{
                    $("#request_invoice").val(0);
                    $("#request_invoice").change();
                }
            });



            this.checkMandatoryInvoice($('select[name="country_id"]').val());


            $('body').on('change', 'select[name="country_id"]', function() {

                var country = $(this).val();
                self.checkMandatoryInvoice(country);
            });

        },

        // requestInvoiceChangeProcessor: function (checkbox) {
        //
        //     self.hideAllFields();
        //     $(".choose-customer-typology").hide();
        //
        //     if (checkbox){
        //         $("#request_invoice").val(1);
        //         $("#request_invoice").change();
        //         if ($(".choose-customer-typology").data("can-choose")){
        //             $(".choose-customer-typology").show();
        //
        //             var radioVal =  $('input[type=radio][name=customer_typology]:checked').val();
        //             if (radioVal==0 || radioVal == undefined) {
        //                 self.showPrivateFields();
        //             }else{
        //                 self.showCompanyFields();
        //             }
        //         }else{
        //             self.showCompanyFields();
        //         }
        //     }else{
        //         $("#request_invoice").val(0);
        //         $("#request_invoice").change();
        //     }
        // },

        checkMandatoryInvoice: function(passed_country) {

            $(".choose-customer-typology").data('can-choose', false);

            if (this.mandatory_countries.includes(passed_country)){
                this.setMandatoryInvoice();
            }else{
                if (passed_country=='IT'){
                    $(".choose-customer-typology").data('can-choose', true);
                }else{
                    $(".choose-customer-typology").data('can-choose', false);
                }

                this.setOptionalInvoice(passed_country);
                $("#show-invoice-fields").trigger('change')
            }

        }

    });
});
