<?php

namespace Drop\Oms\Block\Checkout\Address\Fields;

use Magento\Checkout\Block\Checkout\LayoutProcessorInterface;
use Magento\Framework\DataObject\Copy\Config as CopyConfig;

class ShippingLayoutProcessor implements LayoutProcessorInterface
{
    /**
     * @todo: use helper for fields declaration setter and getter
     */
    const CUSTOMER_TYPOLOGY = 'customer_typology';
    const REQUEST_INVOICE = 'request_invoice';
    const FISCAL_CODE = 'fiscal_code';
    const RECEPTION_DESTINATION = 'fe_reception_destination';

    /**
     * @var CopyConfig
     */
    private $copyConfig;

    /**
     * Fields constructor.
     * @param CopyConfig $copyConfig
     */
    public function __construct(
        CopyConfig $copyConfig
    )
    {
        $this->copyConfig = $copyConfig;

    }

    /**
     * Adding fields to the checkout
     * @param array $result
     * @return array
     */
    public function process($result)
    {

        $result = $this->fieldHiddenRequestInvoice($result, self::REQUEST_INVOICE);
        $result = $this->fieldRequestInvoice($result, self::REQUEST_INVOICE);
        $result = $this->fieldCustomerTypology($result, self::CUSTOMER_TYPOLOGY);
        $result = $this->fieldFiscalCode($result, self::FISCAL_CODE);
        $result = $this->addValidationToPostcode($result);
        return $this->fieldReceptionDestination($result, self::RECEPTION_DESTINATION);
    }

    public function fieldHiddenRequestInvoice($result, $fieldName)
    {
        $requestInvoiceHidden = [
            'component' => 'Magento_Ui/js/form/element/abstract',
            'config' => [
                'customScope' => 'shippingAddress.custom_attributes',
                'customEntry' => null,
                'template' => 'ui/form/field',
                'elementTmpl' => 'Drop_Oms/form/element/hidden-input'
            ]
        ];

        $result
        ['components']
        ['checkout']
        ['children']
        ['steps']
        ['children']
        ['shipping-step']
        ['children']
        ['shippingAddress']
        ['children']
        ['shipping-address-fieldset']
        ['children']
        [$fieldName . "_check"] = $requestInvoiceHidden;

        return $result;
    }

    public function fieldRequestInvoice($result, $fieldName)
    {
        $requestInvoice = [
            'component' => 'Drop_Oms/js/form/element/request-invoice',
            'config' => [
                'customScope' => 'shippingAddress.custom_attributes',
                'customEntry' => null,
                'template' => 'ui/form/field',
                'elementTmpl' => 'Drop_Oms/form/element/request-invoice'
            ],
            'dataScope' => 'shippingAddress.custom_attributes.' . $fieldName,
            'label' => __('Request Invoice'),
            'description' => __('Request Invoice'),
            'provider' => 'checkoutProvider',
            'sortOrder' => 150,
            'validation' => [],
            'filterBy' => null,
            'customEntry' => null,
            'visible' => true,
            'value' => "1",
            'additionalClasses' => 'request_invoice_check oms-invoice-group'
        ];

        $result
        ['components']
        ['checkout']
        ['children']
        ['steps']
        ['children']
        ['shipping-step']
        ['children']
        ['shippingAddress']
        ['children']
        ['shipping-address-fieldset']
        ['children']
        [$fieldName] = $requestInvoice;

        return $result;
    }

    public function fieldCustomerTypology($result, $fieldName)
    {

        $customerTypology = [
            'component' => 'Drop_Oms/js/form/element/customer-typology',
            'config' => [
                'customScope' => 'shippingAddress.custom_attributes',
                'customEntry' => null,
                'template' => 'ui/form/field',
                'elementTmpl' => 'Drop_Oms/form/element/customer-typology',
//                'tooltip' => [
//                    'description' => 'Spiegare che vuol dire privato azienda',
//                ],
            ],
            'dataScope' => 'shippingAddress.custom_attributes.' . $fieldName,
            'label' => __('Customer Typology'),
            'provider' => 'checkoutProvider',
            'sortOrder' => 160,
            'validation' => [
                'customer-typology' => true
            ],
            'options' => [
                ['value' => 0,
                 'id' => 'customer_typology_0',
                 'label' => __('Person')],
                ['value' => 1,
                 'id' => 'customer_typology_1',
                 'label' => __('Business')]
            ],
            'filterBy' => null,
            'customEntry' => null,
            'additionalClasses' => 'customer_typology choose-customer-typology oms-invoice-group',
//            'visible' => true   //Needed for validation
        ];

        $result
        ['components']
        ['checkout']
        ['children']
        ['steps']
        ['children']
        ['shipping-step']
        ['children']
        ['shippingAddress']
        ['children']
        ['shipping-address-fieldset']
        ['children']
        [$fieldName] = $customerTypology;

        return $result;
    }

    public function fieldFiscalCode($result, $fieldName)
    {
        $fiscalCode = [
            'component' => 'Magento_Ui/js/form/element/abstract',
            'config' => [
                'customScope' => 'shippingAddress.custom_attributes',
                'customEntry' => null,
                'template' => 'ui/form/field',
                'elementTmpl' => 'ui/form/element/input',
            ],
            'dataScope' => 'shippingAddress.custom_attributes.' . $fieldName,
            'label' => __('Fiscal Code'),
            'provider' => 'checkoutProvider',
            'sortOrder' => 170,
            'validation' => [
                'fiscal-code' => true
            ],
            'filterBy' => null,
            'customEntry' => null,
            'visible' => true,  //Needed for validation
            'required' => true,
            'additionalClasses' => 'oms-fiscal-code-field oms-invoice-group required',
            'id' => $fieldName
        ];

        $result
        ['components']
        ['checkout']
        ['children']
        ['steps']
        ['children']
        ['shipping-step']
        ['children']
        ['shippingAddress']
        ['children']
        ['shipping-address-fieldset']
        ['children']
        [$fieldName] = $fiscalCode;

        return $result;
    }

    public function fieldReceptionDestination($result, $fieldName)
    {
        $receptionDestination = [
            'component' => 'Magento_Ui/js/form/element/abstract',
            'config' => [
                'customScope' => 'shippingAddress.custom_attributes',
                'customEntry' => null,
                'template' => 'ui/form/field',
                'elementTmpl' => 'ui/form/element/input'
            ],
            'dataScope' => 'shippingAddress.custom_attributes.' . $fieldName,
            'label' => __('Reception Destination'),
            'provider' => 'checkoutProvider',
            'sortOrder' => 190,
            'validation' => [
                'reception-destination' => true,
            ],

            'filterBy' => null,
            'customEntry' => null,
            'visible' => true,  //Needed for validation
            'additionalClasses' => 'oms-destination-field oms-invoice-group required',
            'id' => $fieldName
        ];

        $result
        ['components']
        ['checkout']
        ['children']
        ['steps']
        ['children']
        ['shipping-step']
        ['children']
        ['shippingAddress']
        ['children']
        ['shipping-address-fieldset']
        ['children']
        [$fieldName] = $receptionDestination;

        return $result;
    }

    public function addValidationToPostcode($result) {
        $result
        ['components']
        ['checkout']
        ['children']
        ['steps']
        ['children']
        ['shipping-step']
        ['children']
        ['shippingAddress']
        ['children']
        ['shipping-address-fieldset']
        ['children']
        ['postcode']
        ['validation']
        ['zip-validation'] = true;
        return $result;
    }

}
