<?php

namespace Drop\Oms\Plugin\Magento\Rma;

use Drop\Oms\Helper\ConfigurationHelper;
use Drop\Oms\Model\Rma\Authorize;
use Magento\Rma\Model\Rma;
use Magento\Rma\Model\Rma\Source\Status as RmaStatus;
use Psr\Log\LoggerInterface;

class Model
{
    protected $configuration;
    protected $authorize;

    public function __construct(
        ConfigurationHelper $configurationHelper,
        Authorize           $authorize
    )
    {
        $this->configuration = $configurationHelper;
        $this->authorize = $authorize;
    }

    /**
     * @param $subject
     * @param $result
     * @param $data
     * @return mixed
     */
    public function afterSaveRma($subject, $result, $data)
    {
        if (
            $this->configuration->isReturnsAuthorizeConfigurationEnabled() &&
            $this->configuration->isReturnAutomaticAuthorization() &&
            $result->getStatus() == RmaStatus::STATE_PENDING
        ) {
            $this->authorize->execute($result);
        }

        return $result;
    }
}
