<?php


namespace Drop\Oms\Model;

use Drop\Oms\Helper\ConfigurationHelper;
use \Magento\Catalog\Model\Product\Attribute\Source\Status as ProductStatus;
use \Magento\Catalog\Model\Product\Type as ProductType;
use \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use \Magento\CatalogInventory\Api\StockStateInterface;

class CustomStockApi
{
    protected $configuration;
    protected $collectionFactory;

    /**
     * CustomStockApi constructor.
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory
     */
    public function __construct(
        ConfigurationHelper $configuration,
        CollectionFactory   $collectionFactory
    )
    {
        $this->configuration = $configuration;
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @param $empty
     * @return array|mixed
     */
    public function get($empty = null)
    {
        try {
            return $this->getProductsCollection($empty);
        } catch (\Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }

    /**
     * @param $empty
     * @return mixed
     */
    protected function getProductsCollection($empty)
    {
        if ($this->configuration->useCustomStock() && $this->configuration->getCustomStockId()) {
            return $this->getCustomStockProducts($this->configuration->getCustomStockId());
        }

        return $this->getDefaultStockProducts();
    }

    /**
     * @return mixed
     */
    protected function getDefaultStockProducts()
    {
        $collection = $this->collectionFactory->create()
            ->addAttributeToSelect('*')
            ->joinTable(
                ['stock' => 'cataloginventory_stock_item'],
                'product_id=entity_id',
                ['qty'],
                'is_in_stock=1'
            )
            ->addAttributeToFilter('status', ProductStatus::STATUS_ENABLED)
            ->addAttributeToFilter('type_id', ProductType::TYPE_SIMPLE);

        return $collection->toArray();
    }

    /**
     * @param $stockId
     * @return mixed
     */
    protected function getCustomStockProducts($stockId)
    {
        $collection = $this->collectionFactory->create()
            ->addAttributeToSelect('*')
            ->joinTable(
                ['stock' => 'inventory_stock_' . $stockId],
                'sku=sku',
                ['quantity as qty'],
                'quantity>0'
            )
            ->addAttributeToFilter('status', ProductStatus::STATUS_ENABLED)
            ->addAttributeToFilter('type_id', ProductType::TYPE_SIMPLE);

        return $collection->toArray();
    }
}
