<?php

namespace Drop\Oms\Helper;

use Magento\Store\Model\ScopeInterface;

class Oms extends \Magento\Framework\App\Helper\AbstractHelper
{
    const REQUEST_INVOICE_COUNTRIES = 'oms/general/req_request_invoice_countries';
    const EU_COUNTRIES = 'general/country/eu_countries';
    const ALLOW_COUNTRIES = 'general/country/allow';

    protected $scopeConfig;

    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    )
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @param $countryId
     * @return bool
     */
    public function forceRequestInvoice($countryId)
    {
        $requestInvoiceCountries = $this->getRequestInvoiceCountriesConfiguration();
        $euCountries = $this->getEuCountries();

        if (
            !empty($countryId) && !empty($requestInvoiceCountries) &&
            (
                in_array($countryId, $requestInvoiceCountries) ||
                (!in_array($countryId, $requestInvoiceCountries) && !in_array($countryId, $euCountries))
            )
        ) {
            return true;
        }
        return false;
    }

    /**
     * @return array
     */
    public function printMandatoryCountry()
    {
        $requestInvoiceCountries = $this->getRequestInvoiceCountriesConfiguration();
        $euCountries = $this->getEuCountries();
        $allowedCountries = $this->getAllowCountries();


        foreach ($allowedCountries as $key => $country) {
            if (in_array($country, $euCountries) && !in_array($country, $requestInvoiceCountries)) {
                unset($allowedCountries[$key]);
            }
        }

        return json_encode(array_values($allowedCountries));

    }

    /**
     * @return array
     */
    public function getRequestInvoiceCountriesConfiguration()
    {
        $countries = $this->scopeConfig->getValue(self::REQUEST_INVOICE_COUNTRIES, ScopeInterface::SCOPE_STORE, 0);
        return $countries ? explode(',', $countries) : [];
    }

    /**
     * @return array
     */
    public function getEuCountries()
    {
        $countries = $this->scopeConfig->getValue(self::EU_COUNTRIES, ScopeInterface::SCOPE_STORE, 0);
        return $countries ? explode(',', $countries) : [];
    }

    /**
     * @return array
     */
    public function getAllowCountries()
    {
        $countries = $this->scopeConfig->getValue(self::ALLOW_COUNTRIES, ScopeInterface::SCOPE_STORE);
        return $countries ? explode(',', $countries) : [];
    }

    /**
     * @param $countryId
     * @return bool
     */
    public function canBePrivateCustomer($countryId)
    {
        if ($countryId == 'IT') {
            return true;
        }

        return false;
    }
}
