<?php


namespace Drop\Oms\Helper;


use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Encryption\EncryptorInterface;

class ConfigurationHelper extends AbstractHelper
{
    const XML_SECTION = "oms";
    const XML_GROUP_GENERAL = self::XML_SECTION . "/general";

    const XML_GROUP_PDF = self::XML_SECTION . "/oms_api_configuration";
    const XML_PATH_PDF_ENABLED = self::XML_GROUP_PDF . "/pdf_enabled";
    const XML_PATH_PDF_URL = self::XML_GROUP_PDF . "/url";
    const XML_PATH_PDF_USERNAME = self::XML_GROUP_PDF . "/username";
    const XML_PATH_PDF_PASSWORD = self::XML_GROUP_PDF . "/password";
    const XML_PATH_PDF_LOGIN_ENDPOINT = self::XML_GROUP_PDF . "/login";
    const XML_PATH_PDF_INVOICE_ENDPOINT = self::XML_GROUP_PDF . "/invoice";
    const XML_PATH_PDF_RMA_PROFORMA_ENDPOINT = self::XML_GROUP_PDF . "/rma_proforma";

    const XML_GROUP_RETURNS = self::XML_SECTION . "/returns_configuration";
    const XML_PATH_RETURNS_DAY_LIMIT_ENABLED = self::XML_GROUP_RETURNS . "/enable_rma_day_limit";
    const XML_PATH_RETURNS_DAY_LIMIT = self::XML_GROUP_RETURNS . "/rma_day_limit";
    const XML_PATH_RETURNS_AUTHORIZED_CONFIGURATION_ENABLE = self::XML_GROUP_RETURNS . "/enable_rma_auth_configuration";
    const XML_PATH_RETURNS_AUTOMATIC_AUTHORIZATION = self::XML_GROUP_RETURNS . "/automatic_authorization";
    const XML_PATH_RETURNS_ENABLE_APPROVED_EMAIL = self::XML_GROUP_RETURNS . "/enable_approved_email";
    const XML_PATH_RETURNS_APPROVED_EMAIL_TEMPLATE = self::XML_GROUP_RETURNS . "/approved_email_template";

    const XML_GROUP_RESTRICTION = self::XML_SECTION . "/restriction_configuration";
    const XML_PATH_RESTRICTION_PURCHASEORDER = self::XML_GROUP_RESTRICTION . "/enable_purchaseorder_restriction";
    const XML_PATH_RESTRICTION_FLATRATE = self::XML_GROUP_RESTRICTION . "/enable_flatrate_restriction";

    const XML_GROUP_STOCK = self::XML_SECTION . "/stock_configuration";
    const XML_PATH_STOCK_USE_CUSTOM = self::XML_GROUP_STOCK . "/use_custom_stock";
    const XML_PATH_STOCK_CUSTOM_ID = self::XML_GROUP_STOCK . "/custom_stock_id";
    const XML_PATH_STOCK_CONFIGURABLE_RESET_ENABLED = self::XML_GROUP_STOCK . "/custom_stock_id";
    const XML_PATH_STOCK_RESET_ONLY_OUT = self::XML_GROUP_STOCK . "/custom_stock_id";

    /**
     * ConfigurationHelper constructor.
     * @param Context $context
     * @param EncryptorInterface $encryptor
     */
    public function __construct(
        Context            $context,
        EncryptorInterface $encryptor
    )
    {
        parent::__construct($context);
        $this->encryptor = $encryptor;
    }

    /* GENERAL */


    /* PDF */
    /**
     * @return bool
     */
    public function isPdfEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_PDF_ENABLED);
    }

    /**
     * @return string
     */
    public function getPdfInvoiceUrl(): string
    {
        return (string)$this->scopeConfig->getValue(self::XML_PATH_PDF_URL);
    }

    /**
     * @return string
     */
    public function getPdfInvoiceUsername(): string
    {
        return (string)$this->scopeConfig->getValue(self::XML_PATH_PDF_USERNAME);
    }

    /**
     * @return string
     */
    public function getPdfInvoicePassword(): string
    {
        return $this->encryptor->decrypt((string)$this->scopeConfig->getValue(self::XML_PATH_PDF_PASSWORD));
    }

    /**
     * @return string
     */
    public function getPdfInoviceLoginEndpoint(): string
    {
        return $this->getPdfInvoiceUrl() . (string)$this->scopeConfig->getValue(self::XML_PATH_PDF_LOGIN_ENDPOINT);
    }

    /**
     * @return string
     */
    public function getPdfInvoiceDownloadEndpoint(): string
    {
        return $this->getPdfInvoiceUrl() . (string)$this->scopeConfig->getValue(self::XML_PATH_PDF_INVOICE_ENDPOINT);
    }

    /**
     * @return string
     */
    public function getPdfRmaProformaDownloadEndpoint(): string
    {
        return $this->getPdfInvoiceUrl() . (string)$this->scopeConfig->getValue(self::XML_PATH_PDF_RMA_PROFORMA_ENDPOINT);
    }

    /* RETURNS */
    /**
     * @return bool
     */
    public function isReturnsDayLimitEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_RETURNS_DAY_LIMIT_ENABLED);
    }

    /**
     * @return string
     */
    public function getReturnsDayLimit(): string
    {
        return (string)$this->scopeConfig->getValue(self::XML_PATH_RETURNS_DAY_LIMIT);
    }

    /**
     * @return bool
     */
    public function isReturnsAuthorizeConfigurationEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_RETURNS_AUTHORIZED_CONFIGURATION_ENABLE);
    }

    /**
     * @return bool
     */
    public function isReturnAutomaticAuthorization(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_RETURNS_AUTOMATIC_AUTHORIZATION);
    }

    /**
     * @return bool
     */
    public function isReturnApprovedEmailEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_RETURNS_ENABLE_APPROVED_EMAIL);
    }

    /**
     * @param null $storeId
     * @return string
     */
    public function getReturnApprovedEmailTemplate($storeId = null): string
    {
        return (string)$this->scopeConfig->getValue(self::XML_PATH_RETURN_APPROVED_EMAIL_TEMPLATE, 'store', $storeId);
    }

    /* RESTRICTION CONFIGURATION */
    /**
     * @return bool
     */
    public function isRestrictionPurchaseOrderEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_RESTRICTION_PURCHASEORDER);
    }

    /**
     * @return bool
     */
    public function isRestrictionFlatRateEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_RESTRICTION_FLATRATE);
    }

    /* STOCK CONFIGURATION */
    /**
     * @return bool
     */
    public function useCustomStock(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_STOCK_USE_CUSTOM);
    }

    /**
     * @return int
     */
    public function getCustomStockId(): int
    {
        return (int)$this->scopeConfig->getValue(self::XML_PATH_STOCK_CUSTOM_ID);
    }

    /**
     * @return bool
     */
    public function isConfigurableResetStockEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_STOCK_CONFIGURABLE_RESET_ENABLED);
    }

    /**
     * @return bool
     */
    public function isConfigurableResetStockOnlyOutOfStock(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_STOCK_RESET_ONLY_OUT);
    }

    /* MAGENTO CONFIGURATION */
    /**
     * @return bool
     */
    public function isRmaAuthorizeEmailEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag("sales_email/magento_rma_auth/enabled");
    }
}
