<?php
/**
 * @category    Magento 2
 * @copyright   Copyright (c) 2021 Drop (https://drop.it)
 * @author      Cavallaro <cavallaro@drop.it>
 */

namespace Drop\Oms\Plugin\OfflineShipping\Model;

use Drop\Oms\Helper\ConfigurationHelper;
use Magento\Backend\Model\Auth\Session;
use Magento\OfflineShipping\Model\Carrier\Flatrate;

/**
 * Class RestrictFlatrate
 * @package Drop\AuthorizeRma\Plugin\OfflineShipping\Model
 */
class RestrictFlatrate
{
    private $configuration;
    /**
     * @var Session
     */
    private $backendSession;

    /**
     * @param ConfigurationHelper $configuration
     * @param Session $backendSession
     */
    public function __construct(
        ConfigurationHelper $configuration,
        Session             $backendSession
    )
    {
        $this->configuration = $configuration;
        $this->backendSession = $backendSession;
    }

    /**
     * @param Flatrate $subject
     * @param $result
     * @return mixed
     */
    public function afterGetConfigFlag(Flatrate $subject, $result)
    {
        if (!$this->configuration->isRestrictionFlatRateEnabled() || $this->backendSession->isLoggedIn()) {
            return $result;
        }
        
        return false;
    }
}
