<?php

namespace Drop\Oms\Plugin\Checkout;

use Magento\Checkout\Block\Checkout\LayoutProcessor;
use Drop\Oms\Block\Checkout\Address\Fields\ShippingLayoutProcessor;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

class BillingLayoutProcessor
{
    const XML_DISPLAY_BILLING_ADDRESS_ON = 'checkout/options/display_billing_address_on';

    private $fieldToDelete = [
        ShippingLayoutProcessor::REQUEST_INVOICE,
        ShippingLayoutProcessor::CUSTOMER_TYPOLOGY,
        ShippingLayoutProcessor::FISCAL_CODE,
        ShippingLayoutProcessor::RECEPTION_DESTINATION,
        'vat_id',
        'company',
    ];
    private $scopeConfig;

    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    )
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @param LayoutProcessor $subject
     * @param array $result
     * @return array|mixed
     */
    public function afterProcess(
        LayoutProcessor $subject,
        array $result
    )
    {
        $displayBillingAddressOn = $this->scopeConfig->getValue(self::XML_DISPLAY_BILLING_ADDRESS_ON, ScopeInterface::SCOPE_STORE, 0);

        if ($displayBillingAddressOn == 1) {
            return $this->unsetFromPaymentPage($result);
        }

        return $this->unsetFromPaymentMethod($result);
    }

    /**
     * @param $result
     * @return mixed
     */
    public function unsetFromPaymentPage($result)
    {
        // rimozione campi in caso di configurazione Display Billing Address On => Payment Page
        $paymentMethodPageBillingAddressFields = $result['components']['checkout']['children']['steps']['children']
        ['billing-step']['children']['payment']['children']['afterMethods']['children']
        ['billing-address-form']['children']['form-fields']['children'];
        foreach ($paymentMethodPageBillingAddressFields as $key => $field) {
            if (!in_array($key, $this->fieldToDelete)) {
                continue;
            }

            unset(
                $result
                ['components']
                ['checkout']
                ['children']
                ['steps']
                ['children']
                ['billing-step']
                ['children']
                ['payment']
                ['children']
                ['afterMethods']
                ['children']
                ['billing-address-form']
                ['children']
                ['form-fields']
                ['children']
                [$key]
            );
        }

        return $result;
    }

    /**
     * @param $result
     * @return mixed
     */
    public function unsetFromPaymentMethod($result)
    {
        // rimozione campi in caso di configurazione Display Billing Address On => Payment Method
        $paymentForms = $result['components']['checkout']['children']['steps']['children']
        ['billing-step']['children']['payment']['children']
        ['payments-list']['children'];

        $paymentMethodForms = array_keys($paymentForms);

        if (!isset($paymentMethodForms)) {
            return $result;
        }

        foreach ($paymentMethodForms as $paymentMethodForm) {
            $paymentMethodCode = str_replace('-form', '', $paymentMethodForm, $paymentMethodCode);

            foreach ($this->fieldToDelete as $field) {
                unset(
                    $result
                    ['components']
                    ['checkout']
                    ['children']
                    ['steps']
                    ['children']
                    ['billing-step']
                    ['children']
                    ['payment']
                    ['children']
                    ['payments-list']
                    ['children']
                    [$paymentMethodForm]
                    ['children']
                    ['form-fields']
                    ['children']
                    [$field]
                );
            }
        }

        return $result;
    }

}
