<?php

namespace Drop\Oms\Model\Rma;

use Drop\Oms\Helper\ConfigurationHelper;
use Psr\Log\LoggerInterface;
use Magento\Rma\Model\Item\Attribute\Source\Status as ItemStatus;
use Magento\Rma\Model\Rma\Source\Status as RmaStatus;
use Magento\Rma\Model\Rma\Status\History;
use Magento\Rma\Model\Rma;

class Authorize
{

    private $configuration;
    private $logger;
    private $history;

    /**
     * @param ConfigurationHelper $configurationHelper
     * @param LoggerInterface $logger
     * @param History $history
     */
    public function __construct(
        ConfigurationHelper $configurationHelper,
        LoggerInterface     $logger,
        History             $history
    )
    {
        $this->configuration = $configurationHelper;
        $this->logger = $logger;
        $this->history = $history;
    }

    /**
     * @param Rma $rma
     * @return bool
     */
    public function execute(Rma $rma): bool
    {
        if (
            !$this->configuration->isReturnAutomaticAuthorization() ||
            $rma->getStatus() != RmaStatus::STATE_PENDING
        ) {
            return false;
        }

        foreach ($rma->getItems() as $item) {
            try {
                $item->setQtyAuthorized($item->getQtyRequested());
                $item->setStatus(ItemStatus::STATE_AUTHORIZED);
                $item->save();
            } catch (\Exception $e) {
                $this->logger->error("[AUTHORIZE RETURN ITEM] - {$rma->getIncrementId()} ERROR: {$e->getMessage()}");
            }

        }

        try {
            $rma->setStatus(RmaStatus::STATE_AUTHORIZED)->setIsUpdate(1);
            $rma->save();
        } catch (\Exception $e) {
            $this->logger->error("[AUTHORIZE RETURN] - {$rma->getIncrementId()} ERROR: {$e->getMessage()}");
            return false;
        }

        if ($this->configuration->isRmaAuthorizeEmailEnabled()) {
            $this->history->setRmaEntityId($rma->getEntityId());
            $this->history->sendAuthorizeEmail();
        }

        return true;
    }
}
