<?php
namespace Drop\Oms\Controller\Check;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;
use \Drop\Oms\Helper\Oms as OmsHelper;

class PrivateCustomer extends Action
{
    protected $jsonFactory;

    /**
     * @param Context $context
     */
    public function __construct(
        Context $context,
        \Magento\Framework\Controller\Result\JsonFactory $jsonFactory
    ) {
        parent::__construct($context);
        $this->jsonFactory = $jsonFactory;
    }

    /**
     * @return bool|\Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Json|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $countryId = $this->getRequest()->getParam('country_id');
        if (!isset($countryId)) {
            return false;
        }

        $response = new \Magento\Framework\DataObject();
        $response->setError(false);

        try {
            $response->setData(['canBePrivateCustomer' => $this->helper->canBePrivateCustomer($countryId)]);
        } catch (\Exception $e) {
            $response->setData(['canBePrivateCustomer' => 0]);
        }

        return $this->jsonFactory->create()->setJsonData($response->toJson());
    }
}