<?php

namespace Drop\Oms\Console\Command\Stock;

use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use PHPUnit\TextUI\Exception;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Drop\Oms\Model\Stock\ConfigurableAlignment as Model;

class ConfigurableAlignment extends Command
{
    protected $appState;
    protected $configurableAlignment;

    /**
     * ConfigurableAlignment constructor.
     * @param State $appState
     * @param Model $configurableAlignment
     */
    public function __construct(
        State $appState,
        Model $configurableAlignment
    )
    {
        $this->appState = $appState;
        $this->configurableAlignment = $configurableAlignment;
        parent::__construct();
    }

    protected function configure()
    {
        $this->setName('drop:oms:stock:configurable-alignment');
        $this->setDescription('Manual configurable alignment');
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->appState->setAreaCode(Area::AREA_ADMINHTML);

        try {
            $this->configurableAlignment->process();
        } catch (\Exception $e) {
            throw new \Exception($e->getMessage());
        }
    }
}
