<?php

namespace Drop\Oms\Plugin\Magento\Backend\Block\Widget\Button;

use Drop\Oms\Helper\ConfigurationHelper;
use Magento\Framework\UrlInterface;
use Magento\Framework\App\RequestInterface;

class ToolbarPlugin
{
    protected $configuration;
    protected $urlBuilder;
    protected $request;

    public function __construct(
        ConfigurationHelper $configurationHelper,
        UrlInterface $urlBuilder,
        RequestInterface $request
    )
    {
        $this->configuration = $configurationHelper;
        $this->urlBuilder = $urlBuilder;
        $this->request = $request;
    }

    public function beforePushButtons(
        \Magento\Backend\Block\Widget\Button\Toolbar\Interceptor $subject,
        \Magento\Framework\View\Element\AbstractBlock $context,
        \Magento\Backend\Block\Widget\Button\ButtonList $buttonList
    )
    {

        $this->_request = $context->getRequest();
        if ($this->_request->getFullActionName() == 'sales_order_view' && $this->configuration->isPdfEnabled()) {
            $orderId = $this->request->getParam('order_id');
            $buttonList->add(
                'print-oms-invoice',
                [
                    'label'   => __('Print Oms Invoice'),
                    'onclick' => "setLocation('" . $this->urlBuilder->getUrl('mfe/oms/invoice/order_id/'.$orderId, ['_secure' => true]) . "')",
                    'class'   => 'reset'
                ],
                -1
            );
            $buttonList->add(
                'print-oms-rma-proforma',
                [
                    'label'   => __('Print Oms Rma Proforma'),
                    'onclick' => "setLocation('" . $this->urlBuilder->getUrl('mfe/oms/rmaproforma/order_id/'.$orderId, ['_secure' => true]) . "')",
                    'class'   => 'reset'
                ],
                -1
            );
        }

    }
}
