<?php

namespace Drop\Oms\Cron\Stock;

use Drop\Oms\Helper\ConfigurationHelper;

class ConfigurableAlignment
{
    private $configuration;
    private $alignment;

    /**
     * @param ConfigurationHelper $configuration
     * @param \Drop\Oms\Model\Stock\ConfigurableAlignment $alignment
     */
    public function __construct(
        ConfigurationHelper                         $configuration,
        \Drop\Oms\Model\Stock\ConfigurableAlignment $alignment
    )
    {
        $this->configuration = $configuration;
        $this->alignment = $alignment;
    }

    /**
     * @return void
     * @throws \Exception
     */
    public function execute()
    {
        if (!$this->configuration->isConfigurableResetStockEnabled) {
            return;
        }

        try {
            $this->alignment->process();
        } catch (\Exception $e) {
            throw new \Exception($e->getMessage());
        }
    }
}
