# Magento 2 modulo per la gestione tramite Oms interno

## Installation
- Add the VCS repository to composer:
```sh
$ composer config repositories.drop.fe vcs git@bitbucket.org:dropsrl/drop-module-oms-m2.git
```

- Add the module to composer:
```sh
$ composer require drop/module-oms-m2
```

- Enable module, install and clear magento cache
```sh
$ bin/magento module:enable Drop_Oms
$ bin/magento module:enable setup:upgrade
$ bin/magento module:enable cache:clear
```

## Description

- Aggiunta campo customer address Codice Fiscale (fiscal_code)
- Aggiunta campo customer address Tipologia Cliente (customer_typology)
- Aggiunta campo customer address Richiedi Fattura (request_invoice)
- Aggiunta campo customer address Codice Destinatario / Indirizzo PEC (fe_reception_destination)

Il campo Tipologia Cliente:
- Obbligatorio se fattura
- E' un radio con valori Azienda o Privato
- Aggiungere alle API di magento

Il campo Codice Fiscale:
- Non serve per chi non richiede fattura
- Obbligatorio per i privati
- Non serve per le aziende
- La Ragione Sociale è il nome/cognome del cliente
- Inserire quindi una select con in quali stati deve essere presente sul checkout (preselezionato a IT)
- E' necessaria Validazione (libreria)
- Aggiungere alle API di magento

Il campo Partita IVA:
- Non serve per chi non richiede fattura
- Obbligatorio per le aziende
- Non serve per i privati
- Deve diventare obbligatorio anche il campo Azienda
- Abilitato per gli stessi stati di Richiedi Fattura (da segnalare con un commento sul bo)
- E' necessaria Validazione (libreria)
- Nel momento dell'installazione settare le configurazioni a quello che ci serve

Il campo Richiedi fattura:
- è sempre valorizzato (e nascosto) (FATTURA) se fuori dall'ue
- è opzionale se dentro l'unione europea
- è una checkbox da spuntare, nel momento in cui la spunti compare il campo Tipologia cliente
- Inserire quindi una select con in quali stati deve essere presente sul checkout (preselezionato a eu)
- Aggiungere alle API di magento

Il campo Codice Destinatario / Indirizzo PEC:
- Obbligatorio
- E' necessaria Validazione o email oppure codice a 7 cifre
- Aggiungere alle API di magento? NON SERVE

Aggiunta di questi campi su:
- Account address solo billing (bo + frontend)
- Checkout solo billing

Opzionale:
- Link sotto campo Codice Fiscale non ricordi il tuo codice fiscale? che prova a calcolarlo

## Requirements
- PHP >= 7.2.0
- Mage_Core

## Compatibility
- Magento >= 2.2
- Not tested on 2.1 and 2.0

## Support
If you encounter any problems or bugs, please contact us [here](https://www.drop.it) or create an issue.