<?php
/**
 * @category    Magento 2
 * @copyright   Copyright (c) 2021 Drop (https://drop.it)
 * @author      Cavallaro <cavallaro@drop.it>
 */

namespace Drop\Oms\Plugin\OfflinePayments\Model;

use Drop\Oms\Helper\ConfigurationHelper;
use Magento\Backend\Model\Auth\Session;
use Magento\OfflinePayments\Model\Purchaseorder;

/**
 * Class RestrictPurchaseOrder
 * @package Drop\AuthorizeRma\Plugin\OfflinePayments\Model
 */
class RestrictPurchaseOrder
{
    private $configuration;

    /**
     * @var Session
     */
    private $backendSession;

    /**
     * @param ConfigurationHelper $configuration
     * @param Session $backendSession
     */
    public function __construct(
        ConfigurationHelper $configuration,
        Session $backendSession
    ) {
        $this->configuration = $configuration;
        $this->backendSession = $backendSession;
    }

    /**
     * @param Purchaseorder $subject
     * @param $result
     * @return false
     */
    public function afterIsAvailable(Purchaseorder $subject, $result)
    {
        if (!$this->configuration->isRestrictionPurchaseOrderEnabled() || $this->backendSession->isLoggedIn()) {
            return $result;
        }
        
        return false;
    }
}
