<?php
/**
 * AddCustomField
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Oms\Plugin\Customer\Address;

use Magento\Customer\Block\Address\Edit as Subject;
use Magento\Framework\View\Element\Template;
use Drop\Oms\Block\Address\Edit\Oms;

/**
 * Class AddCustomField
 */
class OmsFields
{

    /**
     * Rewrite address/edit.phtml layout
     * Fix for compatibility issue between Magento 2.2.5 and 2.2.6. This cannot be done via layout.xml
     * @return $this
     */
    protected function _prepareLayout()
    {
        $this->setTemplate('Drop_Oms::address/edit.phtml');
        return $this;
    }

    /**
     * @param Subject $subject
     * @param string $html
     *
     * @return string
     */
    public function afterToHtml(Subject $subject, string $html)
    {
        $customBlock = $this->getChildBlock(Oms::class, $subject);
        $customBlock->setAddress($subject->getAddress());
        //I chose to override the template address/edit.phtml because I cannot get it work. Please help!
//        $html = $this->removeVatIdField($html);
//        $html = $this->removeCompanyField($html);
        return $this->appendBlockBeforeFieldsetEnd($html, $customBlock->toHtml());
    }

    /**
     * @param string $html
     * @param string $childHtml
     *
     * @return string
     */
    private function appendBlockBeforeFieldsetEnd(string $html, string $childHtml)
    {
        $pregMatch = '/\<\/fieldset\>/';
        $pregReplace = $childHtml . '\0';
        return preg_replace($pregMatch, $pregReplace, $html, 1);
    }

//    private function removeVatIdField($html) {
//        return preg_replace('#<div class=\"field taxvat\">(.*?)</div>#is', '', $html);
//    }
//
//    private function removeCompanyField($html) {
//        return preg_replace('#<div class=\"field company \">(.*?)</div></div>#is', '', $html);
//    }

    /**
     * @param string $blockClass
     * @param Template $parentBlock
     *
     * @return mixed
     */
    private function getChildBlock(string $blockClass, Template $parentBlock)
    {
        $blockId = str_replace('\\', '_', $blockClass);
        return $parentBlock->getLayout()->createBlock($blockClass, $blockId);
    }

}
