<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 06/12/22
 * Time: 17.06
 */

namespace Drop\Oms\Model;

//use \Magento\Sales\Model\Order;
use Magento\Sales\Api\OrderRepositoryInterface;

class DeliveryDateApi
{
    protected $orderRepository;

    public function __construct(
        OrderRepositoryInterface $orderRepository
    )
    {
        $this->orderRepository = $orderRepository;
    }

    /**
     * @param $id
     * @param $date
     * @return array|bool[]
     */
    public function set($id, $date)
    {
        try {
            $order = $this->orderRepository->get($id);

            $order->setDropPvsDeliveryDate($date);
            $order->addStatusToHistory($order->getStatus(), "Update delivery date via API: {$date}");
            $this->orderRepository->save($order);
        } catch (\Exception $e) {
            return ['error' => $e->getMessage()];
        }

        return ["success" => true];
    }
}
