<?php


namespace Drop\Oms\Setup;

use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\DB\Ddl\Table;

class UpgradeSchema implements UpgradeSchemaInterface
{
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();
        $connection = $installer->getConnection();

        if ($connection->tableColumnExists('sales_order', 'drop_pvs_delivery_date') === false) {
            $connection->addColumn(
                $setup->getTable('sales_order'),
                'drop_pvs_delivery_date',
                [
                    'type'     => Table::TYPE_DATE,
                    'length'   => 0,
                    'nullable' => true,
                    'comment'  => 'Order delivery date'
                ]
            );
        }
    }
}
