<?php

namespace Drop\Oms\Model\Service;

use Drop\Oms\Helper\ConfigurationHelper;
use Magento\Framework\HTTP\Client\Curl;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Rma\Model\Rma\Status\History;

class PdfDownloader
{
    private $configuration;
    private $curl;
    private $serializer;

    /**
     * PdfDownloader constructor.
     * @param ConfigurationHelper $configurationHelper
     * @param Curl $curl
     * @param SerializerInterface $serializer
     */
    public function __construct(
        ConfigurationHelper $configurationHelper,
        Curl $curl,
        SerializerInterface $serializer
    )
    {
        $this->configuration = $configurationHelper;
        $this->curl = $curl;
        $this->serializer = $serializer;
    }

    /**
     * @param $order
     * @return false|mixed
     */
    public function getInvoice($order)
    {
        if (!$token = $this->getToken()) {
            return false;
        }

        $headers = ["Content-Type" => "application/json", "Authorization" => "Bearer " . $token];
        try {
            $this->curl->setHeaders($headers);
            $this->curl->get($this->configuration->getPdfInvoiceDownloadEndpoint() . $order->getIncrementId());
            $response = $this->serializer->unserialize($this->curl->getBody());

            if (!$response || !isset($response["success"])) {
                return false;
            }

            return $response["data"];
        } catch (\Exception $e) {
            return false;
        }
    }

    /**
     * @param $rma
     * @return false|mixed
     */
    public function getRmaProforma($order)
    {
        if (!$token = $this->getToken()) {
            return false;
        }

        $headers = ["Content-Type" => "application/json", "Authorization" => "Bearer " . $token];
        try {
            $this->curl->setHeaders($headers);
            $this->curl->get($this->configuration->getPdfRmaProformaDownloadEndpoint() . $order->getIncrementId());
            $response = $this->serializer->unserialize($this->curl->getBody());

            if (!$response || !isset($response["success"])) {
                return false;
            }

            return $response["data"];
        } catch (\Exception $e) {
            return false;
        }
    }

    /**
     * @return false|mixed
     */
    private function getToken()
    {
        $params = [
            'email'    => $this->configuration->getPdfInvoiceUsername(),
            'password' => $this->configuration->getPdfInvoicePassword()
        ];
        try {
            $this->curl->post($this->configuration->getPdfInoviceLoginEndpoint(), $params);

            $response = $this->serializer->unserialize($this->curl->getBody());
            if (!$response || !isset($response['success'])) {
                return false;
            }

            return $response["data"]["token"];
        } catch (\Exception $e) {
            return false;
        }
    }
}
