define([], function () {
    'use strict';

    return function (Component) {
        return Component.extend({
            getCustomAttributeLabel: function (attribute) {
                var resultAttribute;

                if (attribute.attribute_code == 'customer_typology') {
                    return;
                }
                if (attribute.attribute_code == 'request_invoice') {
                    return;
                }
                if (attribute.attribute_code == 'request_invoice_check') {
                    return;
                }

                if (typeof attribute === 'string') {
                    return attribute;
                }

                if (attribute.label) {
                    return attribute.label;
                }

                if (typeof this.source.get('customAttributes') !== 'undefined') {
                    resultAttribute = _.findWhere(this.source.get('customAttributes')[attribute['attribute_code']], {
                        value: attribute.value
                    });
                }

                return resultAttribute && resultAttribute.label || attribute.value;
            }

        });
    }
});
