<?php

namespace Drop\Oms\Observer\Customer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use \Drop\Oms\Helper\Oms;

class Address implements ObserverInterface
{
    protected $helper;

    /**
     * Address constructor.
     * @param Oms $helper
     */
    public function __construct(Oms $helper)
    {
        $this->helper = $helper;
    }

    /**
     * @param Observer $observer
     * @throws \Exception
     */
    public function execute(
        Observer $observer
    )
    {
        try {
            $address = $observer->getCustomerAddress();

            // NOT CEE - CEE MANDATORY
            if ($this->helper->forceRequestInvoice($address->getCountryId())) {
                $address->setRequestInvoice(1);
                $address->setCustomerTypology('');
                $address->setFiscalCode('');
                $address->setFeReceptionDestination('');
                $address->setVatId('');
                $address->setCompany('');
            }

//            if(in_array($address->getCountryId(), $this->helper->getEuCountries())) {
//                $address->setCustomerTypology('');
//                $address->setFiscalCode('');
//                $address->setFeReceptionDestination('');
//            }

            // request_invoice = 0
            if ($address->getRequestInvoice() == 0) {
                $address->setCustomerTypology('');
                $address->setFiscalCode('');
                $address->setFeReceptionDestination('');
                $address->setVatId('');
                $address->setCompany('');
            }

            // customer_typology = 0
            if ($address->getCustomerTypology() == 0) {
                $address->setVatId('');
                $address->setCompany('');
            }

            if ($address->getCustomerTypology() == 1) {
                $address->setFiscalCode('');
            }
        } catch (\Exception $e) {
            throw new \Exception($e->getMessage());
        }
    }
}
