<?php

namespace Drop\Oms\Controller\Adminhtml\Oms;


use Drop\Oms\Model\Service\PdfDownloader;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Framework\App\Filesystem\DirectoryList;
use \Magento\Framework\App\Response\Http\FileFactory;
use \Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\Controller\ResultFactory;

class Invoice extends Action
{
    private $orderRepository;
    private $downloader;
    private $fileFactory;
    private $resultRawFactory;
    protected $messageManager;
    protected $resultFactory;

    /**
     * Invoice constructor.
     * @param Context $context
     * @param OrderRepositoryInterface $orderRepository
     * @param PdfDownloader $downloader
     * @param FileFactory $fileFactory
     * @param RawFactory $resultRawFactory
     * @param ManagerInterface $messageManager
     * @param ResultFactory $resultFactory
     */
    public function __construct(
        Context $context,
        OrderRepositoryInterface $orderRepository,
        PdfDownloader $downloader,
        FileFactory $fileFactory,
        RawFactory $resultRawFactory,
        ManagerInterface $messageManager,
        ResultFactory $resultFactory
    )
    {
        parent::__construct($context);
        $this->orderRepository = $orderRepository;
        $this->downloader = $downloader;
        $this->fileFactory = $fileFactory;
        $this->resultRawFactory = $resultRawFactory;
        $this->messageManager = $messageManager;
        $this->resultFactory = $resultFactory;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Raw|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $orderId = $this->getRequest()->getParam('order_id');
        if (!$order = $this->orderRepository->get($orderId)) {
            $this->messageManager->addErrorMessage('Order not found');
            $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
            $resultRedirect->setUrl($this->_redirect->getRefererUrl());
            return $resultRedirect;
        }

        if (!$file = $this->downloader->getInvoice($order)) {
            $this->messageManager->addErrorMessage('File recovery error, contact support');
            $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
            $resultRedirect->setUrl($this->_redirect->getRefererUrl());
            return $resultRedirect;
        }

        try {
            $this->fileFactory->create(
                $file['name'],
                base64_decode($file['content']),
                DirectoryList::MEDIA, //basedir
                'application/octet-stream',
                '' // content length will be dynamically calculated
            );
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
            $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
            $resultRedirect->setUrl($this->_redirect->getRefererUrl());
            return $resultRedirect;
        }
        $resultRaw = $this->resultRawFactory->create();
        return $resultRaw;
    }

}
