define([
    'jquery',
    'mage/translate'
], function ($, $t) {
    'use strict';

    return function (validator) {



        validator.addRule(
            'customer-typology',
            function (value, params, additionalParams) {
                if(!$('.customer_typology').hasClass('fe-required-entry')) {
                    //Check if is required
                    return true;
                }
                if((value != '0') && (value != '1')) {
                    return false;
                }
                return true;
            },
            $.mage.__("Select a Customer Typology.")
        );

        validator.addRule(
            'required-entry-if-visible',
            function (value, params, additionalParams) {

                if ($(".oms-company-field").is(':hidden')){
                    return true;
                }

                if(value == '' || value == undefined) {
                    return false;
                }
                return true;
            },
            $.mage.__("This is a required field.")
        );

        validator.addRule(
            'fiscal-code',
            function (value, params, additionalParams) {

                if ($(".oms-fiscal-code-field").is(':hidden')){
                    return true;
                }

                if(value == '' || value == undefined) {
                    return false;
                }
                var regex = /^[A-Za-z]{6}[0-9]{2}[A-Za-z]{1}[0-9]{2}[A-Za-z]{1}[0-9]{3}[A-Za-z]{1}$/;
                if(!regex.test(value)) {
                    return false;
                }

                if(window.checkoutConfig.oms.fiscalcode_validation == 0) {
                    return true;
                }

                var validation = false;
                $.ajax({
                    url: window.checkoutConfig.oms.fiscal_code_validation_url,
                    data: {
                        'fiscal_code': value
                    },
                    type: 'post',
                    dataType: 'json',
                    context: this,
                    async: false,   //Set blocking request - Cannot set timeout with not async req. Setted in PHP
                }).done(function (response) {
                    if(response.error == false) {
                        validation = true;
                    } else if(response.code == 'timeout') {
                        //If the webservice does not respond within the timeout, let it pass
                        validation = true;
                    }
                }).fail(function (error, textStatus) {
                    if(textStatus == 'timeout') {
                        //If the webservice does not respond within the timeout, let it pass
                        validation = true;
                    }
                    console.log(JSON.stringify(error));
                });
                return validation;
            },
            $.mage.__("Enter a correct Fiscal Code.")
        );

        validator.addRule(
            "vat-id",
            function(value, element, additionalParams) {

                if ($(".oms-taxvat-field").is(':hidden')){
                    return true;
                }

                if(value == '' || value == undefined) {
                    return false;
                }

                var countryId = $('.form-shipping-address select[name="country_id"]').val();
                if(countryId == '' || countryId == undefined) {
                    return false;
                }

                if(window.checkoutConfig.oms.vatid_ws_validation == 0){
                    return true;
                }

                var regex = /^[0-9]{11}$/;
                if(countryId == 'IT' && !regex.test(value)) {
                    if($('#force-vat_id-validation').length) {
                        $('#force-vat_id-validation-container').hide();
                    }
                    return false;
                }

                var validation = false;
                $.ajax({
                    url: window.checkoutConfig.oms.vat_id_validation_url,
                    data: {
                        'vat_id': value,
                        'country_id': countryId
                    },
                    type: 'post',
                    dataType: 'json',
                    context: this,
                    async: false,   //Set blocking request - Cannot set timeout with not async req. Setted in PHP
                }).done(function (response) {
                    if(response.error == false) {
                        validation = true;
                        if($('#force-vat_id-validation').length) {
                            $('#force-vat_id-validation-container').hide();
                        }
                    } else if(response.code == 'timeout') {
                        //If the webservice does not respond within the timeout, let it pass
                        validation = true;
                    } else {
                        //If GOVERNATIVE WEBSERVICE doesn't have the right informations XO
                        if(!$('#force-vat_id-validation').length) {
                                //Add a checkbox to force validation
                                $('.vat_id').after(
                                    '<div class="field choice" id="force-vat_id-validation-container" style="margin-top: 5px;font-size: 11px;">\n' +
                                    '    <input type="checkbox" class="checkbox" name="force-vat_id-validation" id="force-vat_id-validation" style="display: inline;vertical-align: top;">\n' +
                                    '    <label class="label" for="force-vat_id-validation" style="width: calc(100% - 25px);">\n' +
                                    '        <span>' + $t("Are you sure your VAT number is valid? Disable validation.") + '</span><br/>\n' +
                                    '        <small style="color: #e02b27;">' + $t("ATTENTION: Orders with invalid VAT number will not be processed.") + '</small>\n' +
                                    '    </label>\n' +
                                    '</div>'
                                );
                        } else {
                            $('#force-vat_id-validation-container').show();
                        }

                        if($('#force-vat_id-validation').is(":checked")) {
                            validation = true;
                        }
                    }
                }).fail(function (error, textStatus) {
                    if(textStatus == 'timeout') {
                        //If the webservice does not respond within the timeout, let it pass
                        validation = true;
                    }
                    console.log(JSON.stringify(error));
                });
                return validation;
            },
            $.mage.__("Enter a correct Vat ID.")
        );

        validator.addRule(
            'reception-destination',

            function (value, params, additionalParams) {

                if ($(".oms-destination-field").is(':hidden')){
                    return true;
                }

                var pattern = new RegExp(/^(("[\w-+\s]+")|([\w-+]+(?:\.[\w-+]+)*)|("[\w-+\s]+")([\w-+]+(?:\.[\w-+]+)*))(@((?:[\w-+]+\.)*\w[\w-+]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$)|(@\[?((25[0-5]\.|2[0-4][\d]\.|1[\d]{2}\.|[\d]{1,2}\.))((25[0-5]|2[0-4][\d]|1[\d]{2}|[\d]{1,2})\.){2}(25[0-5]|2[0-4][\d]|1[\d]{2}|[\d]{1,2})\]?$)/i);
                var regex = /^[A-Za-z0-9]{7}$/;

                if((value != '') && (pattern.test(value) || regex.test(value))) {
                    return true;
                }
                return false;
            },
            $.mage.__("Enter a PEC email address or the Destination Code.")
        );

        var notValidItalianZip = [
            '00000',
            '11111',
            '22222',
            '33333',
            '44444',
            '55555',
            '66666',
            '77777',
            '88888',
            '99999',
            '12345',
        ];

        validator.addRule(
            'zip-validation',
            function (value, params, additionalParams) {

                var countryId = $('.form-shipping-address select[name="country_id"]').val();
                if((countryId != 'IT')) {
                    return true;
                }

                var regex = /^[0-9]{5}$/;
                if(regex.test(value) && !(notValidItalianZip.indexOf(value) > -1)) {
                    return true;
                }

                return false;
            },
            $.mage.__("Enter a correct ZIP.")
        );

        return validator;
    };
});
