<?php


namespace Drop\Oms\Helper;


use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Encryption\EncryptorInterface;

class ConfigurationHelper extends AbstractHelper
{
    const XML_SECTION = "oms";
    const XML_GROUP_PDF = self::XML_SECTION . "/oms_api_configuration";
    const XML_PATH_PDF_ENABLED = self::XML_GROUP_PDF . "/pdf_enabled";
    const XML_PATH_PDF_URL = self::XML_GROUP_PDF . "/url";
    const XML_PATH_PDF_USERNAME = self::XML_GROUP_PDF . "/username";
    const XML_PATH_PDF_PASSWORD = self::XML_GROUP_PDF . "/password";
    const XML_PATH_PDF_LOGIN_ENDPOINT = self::XML_GROUP_PDF . "/login";
    const XML_PATH_PDF_INVOICE_ENDPOINT = self::XML_GROUP_PDF . "/invoice";
    const XML_PATH_PDF_RMA_PROFORMA_ENDPOINT = self::XML_GROUP_PDF . "/rma_proforma";


    /**
     * ConfigurationHelper constructor.
     * @param Context $context
     * @param EncryptorInterface $encryptor
     */
    public function __construct(
        Context $context,
        EncryptorInterface $encryptor
    )
    {
        parent::__construct($context);
        $this->encryptor = $encryptor;
    }
    
    /**
     * @return bool
     */
    public function isPdfEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_PDF_ENABLED);
    }

    /**
     * @return string
     */
    public function getPdfInvoiceUrl(): string
    {
        return (string)$this->scopeConfig->getValue(self::XML_PATH_PDF_URL);
    }

    /**
     * @return string
     */
    public function getPdfInvoiceUsername(): string
    {
        return (string)$this->scopeConfig->getValue(self::XML_PATH_PDF_USERNAME);
    }

    /**
     * @return string
     */
    public function getPdfInvoicePassword(): string
    {
        return $this->encryptor->decrypt((string)$this->scopeConfig->getValue(self::XML_PATH_PDF_PASSWORD));
    }

    /**
     * @return string
     */
    public function getPdfInoviceLoginEndpoint(): string
    {
        return $this->getPdfInvoiceUrl() . (string)$this->scopeConfig->getValue(self::XML_PATH_PDF_LOGIN_ENDPOINT);
    }

    /**
     * @return string
     */
    public function getPdfInvoiceDownloadEndpoint(): string
    {
        return $this->getPdfInvoiceUrl() . (string)$this->scopeConfig->getValue(self::XML_PATH_PDF_INVOICE_ENDPOINT);
    }

    /**
     * @return string
     */
    public function getPdfRmaProformaDownloadEndpoint(): string
    {
        return $this->getPdfInvoiceUrl() . (string)$this->scopeConfig->getValue(self::XML_PATH_PDF_RMA_PROFORMA_ENDPOINT);
    }
}
