<?php


namespace Drop\Oms\Model;

use \Magento\Catalog\Model\Product\Attribute\Source\Status as ProductStatus;
use \Magento\Catalog\Model\Product\Type as ProductType;
use \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use \Magento\CatalogInventory\Api\StockStateInterface;

class CustomStockApi
{
    protected $collectionFactory;

    /**
     * CustomStockApi constructor.
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory
     */
    public function __construct(
        CollectionFactory $collectionFactory
    )
    {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @param $empty
     * @return array|mixed
     */
    public function get($empty = null)
    {
        try {
            return $this->getProductsCollection($empty);
        } catch (\Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }

    /**
     * @param $empty
     * @return mixed
     */
    protected function getProductsCollection($empty)
    {
        $collection = $this->collectionFactory->create()
            ->addAttributeToSelect('*')
            ->joinTable(
                ['stock' => 'cataloginventory_stock_item'],
                'product_id=entity_id',
                ['qty'],
                'is_in_stock=1'
            )
            ->addAttributeToFilter('status', ProductStatus::STATUS_ENABLED)
            ->addAttributeToFilter('type_id', ProductType::TYPE_SIMPLE);

        return $collection->toArray();
    }
}
