<?php
/**
 * ConfigProvider
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Oms\Model;

use Magento\Checkout\Model\ConfigProviderInterface;

class ConfigProvider implements ConfigProviderInterface
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlBuilder;
    /**
     * @var \Drop\Oms\Helper\Oms
     */
    private $helper;

    /**
     * ConfigProvider constructor.
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\UrlInterface $urlBuilder
     * @param \Drop\Oms\Helper\Oms $helper
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\UrlInterface                    $urlBuilder,
        \Drop\Oms\Helper\Oms                               $helper
    )
    {
        $this->scopeConfig = $scopeConfig;
        $this->urlBuilder = $urlBuilder;
        $this->helper = $helper;
    }

    /**
     * @return array
     */
    public function getConfig()
    {
        $config = [];
        $config['oms']['debug'] = $this->scopeConfig->getValue('oms/general/debug');
        $config['oms']['mandatory_invoice_countries'] = $this->helper->printMandatoryCountry();
        $vatIdValidation = $this->scopeConfig->getValue('oms/general/vatid_ws_validation');
        $config['oms']['vatid_ws_validation'] = $vatIdValidation ? explode(',', $vatIdValidation) : [];
        $fiscalCodeValidation = $this->scopeConfig->getValue('oms/general/fiscalcode_validation');
        $config['oms']['fiscalcode_validation'] = $fiscalCodeValidation ? explode(',', $fiscalCodeValidation) : [];
        $config['oms']['vat_id_validation_url'] = $this->urlBuilder->getUrl('mfe/validation/vatid', ['_secure' => true]);
        $config['oms']['fiscal_code_validation_url'] = $this->urlBuilder->getUrl('mfe/validation/fiscalcode', ['_secure' => true]);
        return $config;
    }
}
