<?php

namespace Drop\Oms\Observer\Sales;

use Drop\Oms\Block\Checkout\Address\Fields\ShippingLayoutProcessor;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Model\QuoteRepository;
use Magento\Sales\Model\Order;
use Psr\Log\LoggerInterface;

class QuoteSubmitBefore implements ObserverInterface
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var QuoteRepository
     */
    private $quoteRepository;

    /**
     * QuoteSubmitBefore constructor.
     * @param QuoteRepository $quoteRepository
     * @param LoggerInterface $logger
     */
    public function __construct(
        QuoteRepository $quoteRepository,
        LoggerInterface  $logger
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->logger = $logger; // @todo: custom logger
    }

    public function execute(
        Observer $observer
    ) {
        /** @var Order $order */
        $order = $observer->getOrder();
        $quote = $this->quoteRepository->get($order->getQuoteId());

        try {
            $this->orderBillingAddressFields($order, $quote);
            $this->orderShippingAddressFields($order, $quote);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
        }
    }

    /**
     * Override billing with shipping information (show invoice request only on shipping address )
     * @param $order
     * @param $quote
     * @return $this
     */
    private function orderBillingAddressFields($order, $quote)
    {
        if(!$order->getBillingAddress() || !$quote->getShippingAddress()) {
            return $this;
        }

        $order->getBillingAddress()->setData(
            ShippingLayoutProcessor::CUSTOMER_TYPOLOGY,
            $quote->getShippingAddress()->getData(ShippingLayoutProcessor::CUSTOMER_TYPOLOGY)
        );
        $order->getBillingAddress()->setData(
            ShippingLayoutProcessor::REQUEST_INVOICE,
            $quote->getShippingAddress()->getData(ShippingLayoutProcessor::REQUEST_INVOICE)
        );
        $order->getBillingAddress()->setData(
            ShippingLayoutProcessor::FISCAL_CODE,
            $quote->getShippingAddress()->getData(ShippingLayoutProcessor::FISCAL_CODE)
        );
        $order->getBillingAddress()->setData(
            ShippingLayoutProcessor::RECEPTION_DESTINATION,
            $quote->getShippingAddress()->getData(ShippingLayoutProcessor::RECEPTION_DESTINATION)
        )->save();

        return $this;
    }

    private function orderShippingAddressFields($order, $quote)
    {
        if(!$order->getShippingAddress() || !$quote->getShippingAddress()) {
            return $this;
        }

        $order->getShippingAddress()->setData(
            ShippingLayoutProcessor::CUSTOMER_TYPOLOGY,
            $quote->getShippingAddress()->getData(ShippingLayoutProcessor::CUSTOMER_TYPOLOGY)
        );
        $order->getShippingAddress()->setData(
            ShippingLayoutProcessor::REQUEST_INVOICE,
            $quote->getShippingAddress()->getData(ShippingLayoutProcessor::REQUEST_INVOICE)
        );
        $order->getShippingAddress()->setData(
            ShippingLayoutProcessor::FISCAL_CODE,
            $quote->getShippingAddress()->getData(ShippingLayoutProcessor::FISCAL_CODE)
        );
        $order->getShippingAddress()->setData(
            ShippingLayoutProcessor::RECEPTION_DESTINATION,
            $quote->getShippingAddress()->getData(ShippingLayoutProcessor::RECEPTION_DESTINATION)
        )->save();

        return $this;
    }
}
