<?php


namespace Drop\Oms\Model;

use \Magento\Catalog\Model\Product\Attribute\Source\Status as ProductStatus;
use \Magento\Catalog\Model\Product\Type as ProductType;
use \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use \Magento\CatalogInventory\Api\StockStateInterface;
use \Magento\CatalogInventory\Model\ResourceModel\Stock\Status as StockStatus;

class CustomStockApi
{
    protected $collectionFactory;
    protected $stockState;
    protected $stockStatus;

    /**
     * CustomStockApi constructor.
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory
     * @param \Magento\CatalogInventory\Api\StockStateInterface $stockState
     * @param \Magento\CatalogInventory\Model\ResourceModel\Stock\Status $stockStatus
     */
    public function __construct(
        CollectionFactory $collectionFactory,
        StockStateInterface $stockState,
        StockStatus $stockStatus
    )
    {
        $this->collectionFactory = $collectionFactory;
        $this->stockState = $stockState;
        $this->stockStatus = $stockStatus;
    }

    /**
     * @param $empty
     * @return array|mixed
     */
    public function get($empty = null)
    {
        try {
            return $this->getProductsCollection($empty);
        } catch (\Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }

    /**
     * @param $empty
     * @return mixed
     */
    protected function getProductsCollection($empty)
    {
        $collection = $this->collectionFactory->create()
            ->addAttributeToSelect('*')
            ->joinTable(
                ['stock' => 'cataloginventory_stock_status'],
                'product_id=entity_id',
                ['qty'],
                'stock_status=1'
            )
            ->addAttributeToFilter('status', ProductStatus::STATUS_ENABLED)
            ->addAttributeToFilter('type_id', ProductType::TYPE_SIMPLE);

        return $collection->toArray();
    }
}
